/*jslint browser: true, todo: true*/
/*global ko, Gira, $, _, TODO*/
(function (ns) {
    "use strict";
    var iconType = {
            big: "icon-w_x2_",
            small: "icon-w_",
            blue: "icon-b_"
        };

    function WeatherSymbols() {
        var symbols = null,
            empty = {text1: "---", text2: ""},
            defaultIcon = "weathericon_default";

        function init(weatherSymbols) {
            symbols = weatherSymbols;
        }

        function getText(symbol) {
            var item;
            if (symbol === undefined || symbol === null) {
                return empty;
            }
            symbol = symbol.trim();
            if (symbol.trim() === "") {
                return empty;
            }
            if (symbols === null) {
                return empty;
            }
            item = symbols[symbol];
            return item !== undefined ? item : empty;
        }

        function getDefaultIcon(iconTypes) {
            if (iconTypes === iconType.big) {
                return iconType.big + defaultIcon;
            }
            return "icon-" + defaultIcon;
        }

        function getIcon(iconType, symbol) {
            var item;
            symbol = symbol.trim();
            item = symbols[symbol];
            if (item === undefined) {
                return getDefaultIcon(iconType);
            }
            return iconType + symbol;
        }
        function getBigIcon(symbol) {
            return getIcon(iconType.big, symbol);
        }

        function getSmallIcon(symbol) {
            return getIcon(iconType.small, symbol);
        }

        function getBlueIcon(symbol) {
            return getIcon(iconType.blue, symbol);
        }

        function getSymbols() {
            return symbols;
        }

        return {
            init: init,
            getSymbols: getSymbols,
            getText: getText,
            getBigIcon: getBigIcon,
            getSmallIcon: getSmallIcon,
            getBlueIcon: getBlueIcon
        };
    }

    ns.WeatherSymbols = WeatherSymbols;
}(Gira.Weather));

//# sourceURL=weather.symbols.js
