/*global ko, $, registerEventsBase, window, setTimeout*/
(function () {
    "use strict";
    var catchAll = function (action) {
        try {
            action();
        } catch (ignore) {}
    };

    ko.bindingHandlers.paging = {
        init: function (element, valueAccessor) {
            var data = ko.unwrap(valueAccessor)(),
                index = data.index,
                activeIndex = data.activeIndex,
                element$ = $(element),
                model = data.viewModel,
                setClasses = function (initial) {
                    if (index === activeIndex()) {
                        if (!initial) {
                            element$.addClass('active-page');
                            if (model && (typeof model.isActive === 'function')) {
                                model.isActive(true);
                            }
                        } else {
                            element$.addClass('first-page');
                        }
                        element$.removeClass('prev-page');
                        element$.removeClass('next-page');
                    } else {
                        element$.removeClass('active-page');
                        if (model && (typeof model.isActive === 'function')) {
                            model.isActive(false, index < activeIndex());
                        }
                        element$.removeClass('first-page');
                    }
                    if (index < activeIndex()) {
                        element$.addClass('prev-page');

                    }
                    if (index > activeIndex()) {
                        element$.addClass('next-page');
                    }
                };
            setClasses(true);
            activeIndex.subscribe(function () {
                setClasses(false);
            });
        }
    };

    ko.bindingHandlers.fading = {
        init: function (element, valueAccessor) {
            var data = ko.unwrap(valueAccessor)(),
                index = data.index,
                activeIndex = data.activeIndex,
                element$ = $(element),
                setClasses = function () {
                    if (index === activeIndex()) {
                        element$.removeClass('fade-out');
                        element$.addClass('fade-in');
                    } else {
                        element$.removeClass('fade-in');
                        element$.addClass('fade-out');
                    }
                };
            setClasses();
            activeIndex.subscribe(function () {
                setClasses();
            });
        }
    };

    ko.bindingHandlers.listItemWithSelection = {
        init: function (element, valueAccessor) {
            catchAll(function () {
                var boundProperty = valueAccessor,
                    domElement = $('#' + element.id);

                function onEntryDown(settingsEntry) {
                    if (!settingsEntry.hasClass('wizard-down') && !settingsEntry.hasClass('inactive')) {
                        settingsEntry.addClass('wizard-down');
                        settingsEntry.find('.wizard-flow-top').css('visibility', 'visible');
                        settingsEntry.find('.wizard-settings-row-text.wizard-sub-menu-text').removeClass('t2sg').addClass('t2ws');
                    }
                }

                function onEntryUp(settingsEntry) {
                    if (settingsEntry.hasClass('wizard-down')) {
                        settingsEntry.removeClass('wizard-down');
                        settingsEntry.find('.wizard-flow-top').css('visibility', 'hidden');
                        settingsEntry.find('.wizard-settings-row-text.wizard-sub-menu-text').removeClass('t2ws').addClass('t2sg');
                    }
                }

                function eventsOn(settingsEntryJQuery) {
                    registerEventsBase(settingsEntryJQuery,
                        function (e) {
                            onEntryDown(settingsEntryJQuery, e);
                        },
                        function () {
                            onEntryUp(settingsEntryJQuery);
                        },
                        function () {
                            if (settingsEntryJQuery.hasClass("ignorerowevent") || settingsEntryJQuery.hasClass("inactive")) {
                                return;
                            }
                            settingsEntryJQuery.trigger('settingsEntryAction');
                        }, {
                            stopPropagation: false,
                            ignoreY: false,
                            callUpFunction4TouchMove: true,
                            callClickAction4TouchEnd: false
                        });
                }

                eventsOn(domElement);
                domElement.on('settingsEntryAction', function () {
                    catchAll(function () {
                        var value = boundProperty();
                        value();
                    });
                });
            });
        }
    };

    /*jslint unparam:true*/
    ko.bindingHandlers.wizardSwiperToTop = {
        init: function (element, valueAccessor, allBindings, viewModel) {
            catchAll(function () {
                var swiper,
                    $elem = $(element),
                    currentViewModel = viewModel;

                swiper = $elem.data("swiper");

                currentViewModel[valueAccessor()].subscribe(function () {
                    if (swiper) {
                        swiper.swipeTo(0);
                    }
                });
            });
        }
    };

    /*jslint unparam:true*/
    ko.bindingHandlers.wizardLicenseSwiperReInit = {
        init: function (element, valueAccessor) {
            catchAll(function () {
                var swiperLicense,
                    $elem = $(element);

                swiperLicense = $elem.data("swiper");

                valueAccessor().subscribe(function (newValue) {
                    if (newValue === "reInit" && swiperLicense) {
                        swiperLicense.reInit();
                        setTimeout(function () {
                            swiperLicense.swipeTo(0, 0, false);
                        }, 110);
                    }
                    if (newValue === "swipeTo" && swiperLicense) {
                        swiperLicense.swipeTo(0, 0, false);
                    }
                });
            });
        }
    };


}());
