/*global ko, $, gds$, _*/
/*jslint browser: true*/

(function (ns, ko) {
    "use strict";

    function LicenceViewModel(translate, licenseData, languageSelectionModel) {
        var accepted = ko.observable(false),
            licenceVM = new window.Gira.LicenseViewModel(false, licenseData),
            chosenLicenseLang = "de";

        languageSelectionModel.selected.subscribe(function (language) {
            chosenLicenseLang = language;
        });

        function onLicenceAccepted() {
            accepted(!accepted());
        }
        function isActive(active, goingToNextPage) {
            if (active && licenceVM.setLicenseByLanguageCode(chosenLicenseLang)) {
                licenceVM.updateCompleted('reInit');
            }
            if (!active) {
                if (!goingToNextPage) {
                    accepted(false);
                }
                setTimeout(function () {
                    licenceVM.updateCompleted('swipeTo');
                }, 500);

            }
        }

        return {
            pageTitle: translate.i18n('pageLicenceTitle'),
            pageInfo: translate.i18n('pageLicenceInfo'),
            accepted : accepted,
            isValid: function () { return accepted(); },
            onLicenceAccepted: onLicenceAccepted,
            licenceTextViewModel : licenceVM,
            isActive: isActive

        };
    }

    ns.LicenceViewModel = LicenceViewModel;

}(window, ko));