/*global ko, $, gds$, _*/
/*jslint browser: true*/

(function (ns, ko) {
    "use strict";

    function InstallationEnvironmentViewModel(translate, worldViewModel) {
        var environmentsData = [
                {value: "TastsensorX", name: translate.i18n("configTastsensorXText")},
                {value: "DCS", name: translate.i18n("configWorldsDCSOnlyText")}
            ],
            worldsData = [
                {value: "DCS", name: translate.i18n("configWorldsDCSText")},
                {value: "WEATHER", name: translate.i18n("configWorldsWeatherText")}
            ],
            environments = ko.observableArray(environmentsData),
            selected = ko.observable("TastsensorX");

        function init() {
            worldViewModel.init(worldsData);
        }

        selected.subscribe(function (env) {
            if (env === "TastsensorX") {
                worldViewModel.init(worldsData);
            } else {
                worldViewModel.init([worldsData[1]]);
            }
        });

        return {
            pageTitle: translate.i18n('pageInstallationEnvironmentTitle'),
            pageInfo: translate.i18n('pageInstallationEnvironmentInfo'),
            environments: environments,
            selected: selected,
            init: init,
            isValid: function () { return true; }
        };
    }

    function WorldViewModel(translate) {
        var worlds = ko.observableArray(),
            selected = ko.observableArray();

        function init(worldsData) {
            selected([]);
            worlds(worldsData);
        }

        function setSelected(world) {
            var pos = this.selected.indexOf(world.value);
            if (pos < 0) {
                this.selected.push(world.value);
            } else {
                this.selected.splice(pos, 1);
            }
        }

        return {
            pageTitle: translate.i18n('pageWorldsTitle'),
            pageInfo: translate.i18n('pageWorldsInfo'),
            worlds: worlds,
            selected: selected,
            init: init,
            setSelected: setSelected,
            isValid: function () { return true; }
        };
    }

    ns.WorldViewModel = WorldViewModel;
    ns.InstallationEnvironmentViewModel = InstallationEnvironmentViewModel;

}(window, ko));