/*global ko, _*/
/*jslint browser: true*/
(function (ns) {
    "use strict";
    var Log = window.Gira.Log;

    function DeviceConfigurationInterface(gds) {
        var ipcObj,
            ipcLastChanges = {},
            events = {},
            eventsList = {
                onWifiChanged: "NetworkTechnologies_wifi_Powered",
                onKnxReliableChanged: "KnxReliable"
            },
            formatValue = function (eventName, value) {
                if (value === undefined) {
                    return value;
                }

                switch (eventName) {
                case eventsList.onKnxReliableChanged:
                case eventsList.onWifiChanged:
                    return value === "true";
                default:
                    return value;
                }
            },
            getValue = function (eventName, ipc) {
                var value,
                    obj = ipc !== undefined || ipcObj === undefined ? ipc : ipcObj,
                    lastChangedValue = ipcLastChanges[eventName];
                if (lastChangedValue !== undefined) {
                    return formatValue(eventName, lastChangedValue);
                }
                if (obj !== undefined) {
                    value = obj[eventName];
                    return formatValue(eventName, value);
                }
                return undefined;
            },
            notify = function (newIpc) {
                var eventName,
                    eventNames,
                    callCallback = function (itemCallback) {
                        try {
                            var val = getValue(eventName),
                                newVal = formatValue(eventName, newIpc[eventName]),
                                lastChanged = formatValue(eventName, ipcLastChanges[eventName]);
                            if (val !== newVal && lastChanged === undefined) {
                                itemCallback(newVal);
                            } else {
                                if (lastChanged !== undefined && lastChanged === newVal) {
                                    delete ipcLastChanges[eventName];
                                }
                            }
                        } catch (ex) {
                            Log.exception(ex);
                        }
                    };

                eventNames = Object.getOwnPropertyNames(newIpc);
                eventNames.forEach(function (name) {
                    var event = events[name];
                    eventName = name;
                    if (event !== undefined) {
                        event.forEach(callCallback);
                    }
                });
            },
            storeIpcAndNotify = function (ipc) {
                notify(ipc);
                ipcObj = ipc;
            },
            updateDeviceConfiguration = function () {
                gds.updateDeviceConfiguration(true, function (ipc) {
                    storeIpcAndNotify(ipc);
                });
            },
            init = function () {
                ipcLastChanges = {};
                gds.ready(function () {
                    updateDeviceConfiguration();
                });
                gds.addConfigurationHandler(function (config) {
                    if (config && config.configuration.what === "Device") {
                        updateDeviceConfiguration();
                    }
                });
            },
            rebootDevice = function () {
                gds.send(JSON.stringify({request: {"command": "Restart", "type": "Device"}}));
            };

        function offEvent(eventName, callback) {
            var index,
                event = events[eventName];
            if (event === undefined) {
                return;
            }

            index = event.indexOf(callback);
            if (index > -1) {
                event.splice(index, 1);
            }
        }

        function onEvent(eventName, callback) {
            var value;
            offEvent(eventName, callback);
            if (!events[eventName]) {
                events[eventName] = [];
            }
            events[eventName].push(callback);
            value = getValue(eventName);
            if (value !== undefined) {
                callback(value);
            }
        }

        function getOnWifiChangedRequest(eventName, value) {
            var obj = {};
            obj[eventName] = value.toString();
            obj.NetworkTechnologies_ethernet_Powered = (!value).toString();
            return obj;
        }

        function setValue(eventName, value) {
            var obj = {};
            if (eventsList.onWifiChanged === eventName) {
                obj = getOnWifiChangedRequest(eventName, value);
            } else {
                obj[eventName] = value.toString();
            }
            ipcLastChanges[eventName] = value.toString();
            gds.setDeviceConfigurationValue(true, obj);
        }

        function getSetValueInternal(eventName, value) {
            if (value !== undefined) {
                setValue(eventName, value);
                return undefined;
            }
            return getValue(eventName);
        }

        function isWifiOn(isOn) {
            return getSetValueInternal(eventsList.onWifiChanged, isOn);
        }

        function isKnxReliable(isOn) {
            return getSetValueInternal(eventsList.onKnxReliableChanged, isOn);
        }

        return {
            events: eventsList,
            network: {
                isKnxReliable: isKnxReliable,
                wifi: {isWifiOn : isWifiOn}
            },
            init: init,
            on: onEvent,
            getValue: getValue,
            setValue: setValue,
            rebootDevice: rebootDevice
        };
    }

    ns.DeviceConfigurationInterface = DeviceConfigurationInterface;
}(window.Gira));

