/*global window, $, gds$*/
(function (ns) {
    "use strict";

    function init() {
        ns.ModuleLoader.init();
        ns.dateTimeFormatsModel = new ns.DateTimeFormats(ns.appLang.appI18nTexts, gds$, $.ajax({
            url: "js/gira.dateTimeFormats.json",
            async: false
        }).responseText);

        ns.deviceConfig = new ns.DeviceConfigurationInterface(gds$);
        ns.deviceConfig.init();
        ns.networkModel = new ns.NetworkModel(ns.deviceConfig, window.Gira.appLang.appI18nTexts, window.fsm.API.SystemMessage);
        ns.networkRealibleModel = new ns.KnxReliableModel(ns.deviceConfig, window.Gira.appLang.appI18nTexts, window.fsm.API.SystemMessage);
    }

    function Bootstrapper() {
        return {
            init: init
        };
    }

    ns.Bootstrapper = Bootstrapper;
}(window.Gira));