/* 
 * REQUIRES Template.js Helperfunctions.js!!!
 */

/**
 * 
 * Popup
 */
function Popup()
{
    this._buttons = new Array();
}
;

/**
 * Adds a button to the Popup
 * 
 * @param {PopupButton} newButton 
 *          new Button in the Popup
 */
Popup.prototype.addButton = function(newButton)
{
    if (newButton === null) {
        throw "newButton == null";
    }
    if ($.inArray(newButton, this._buttons) !== -1) {
        throw "Button already in Popup registered.";
    }

    this._buttons.push(newButton);

    return this;
};

/**
 * sets the Headline to the Popup
 * 
 * @param {string} caption 
 *          Headline text
 */
Popup.prototype.setHeadline = function(caption)
{
    var headline = _findElement(new Array('popup-overlay', 'popup-container', 'headline', 'headlinetext'));
    headline.html(caption);
};

/**
 * Changes the Text in the Popup ValueTextField
 * 
 * @param {array} cssPath 
 *          DOM path of the textfield
 * @param {string} value
 *          Text value
 */
Popup.prototype.changePopupTextControl = function(cssPath, value) {
    var parent = _findElement(cssPath);
    var newParent = parent.find('span');
    var newText = parseInt(value) + '%';
    newParent.html(newText);
}
;

/**
 * Changes the enabled/disabled status of the Ok button in the Numeric Popup
 * 
 * @param {array} cssPath 
 *          DOM path of the OK button
 * @param {string} value
 *          Boolean value
 */
Popup.prototype.changeOkButtonStatus = function (active) {
    var parent = document.getElementById("btnNumOK");
    var newParent = _findElement(new Array("btnNumOK", "inner"));
    if (!active) {
        parent.setAttribute("disabled", "true");
        newParent.removeClass("black").addClass("gray");
    } else {
        parent.removeAttribute("disabled");
        newParent.removeClass("gray").addClass("black");
    }
}
;

/**
 * 
 *  PopupButton functions
 * 
 * @param {array} cssPath
 * @param {string} skip
 * @param {string} min
 * @param {string} max
 * @param {array} valueCssPath
 */
function PopupButton(cssPath, tag, skip, min, max, valueCssPath)
{
    this._cssPath = cssPath;
    this._tag = tag;
    this._skip = skip;
    this._min = min;
    this._max = max;
    this._button;
    this._valueCssPath = valueCssPath;

    this._popupinterval_down = 0x1;
    this._popupinterval_up = 0x2;

    this._popupIntervalTimer = 0;
    this._popupInterval = 800;
}

/**
 * Functionality for the ActionRepeatButton 
 * setTimeout in mousedown: start from 800ms
 * if timeout is gone, check for more values 750, 700, 650, 600, 550, 500, 450, 400, 350, 300, 300, 300, 300, 300
 */
PopupButton.prototype.popupActionSendButton = function()
{
    this._button = _findElement(this._cssPath);
    this._popupButtonEvents();
}
;

/*
 * setTimeout in mousedown: start from 800ms
 * if timeout is gone, check for more values 750, 700, 650, 600, 550, 500, 450, 400, 350, 300, 300, 300, 300, 300
 */
/**
 * checks the Timeout of the Buttonpress
 * @param {jqeryelement} button
 * @param {object} direction
 * @private
 */
PopupButton.prototype._checkTimeout = function(button, direction) {

    var popupbutton = this;
    homeServerClient.sendTagValue(this._tag, this._getPopupElementNewValue(direction));

    switch (this._popupInterval) {
        case 800:
            this._popupInterval = 750;
            break;
        case 750:
            this._popupInterval = 700;
            break;
        case 700:
            this._popupInterval = 650;
            break;
        case 650:
            this._popupInterval = 600;
            break;
        case 600:
            this._popupInterval = 550;
            break;
        case 550:
            this._popupInterval = 500;
            break;
        case 500:
            this._popupInterval = 450;
            break;
        case 450:
            this._popupInterval = 400;
            break;
        case 400:
            this._popupInterval = 350;
            break;
        case 350:
        default:
            this._popupInterval = 300;
            break;
    }

    clearInterval(this._popupIntervalTimer);

    this._popupIntervalTimer = setTimeout(function() {
        popupbutton._checkTimeout(button, direction);
    }, this._popupInterval);
}
;

/**
 * events for the button
 * @private
 */
PopupButton.prototype._popupButtonEvents = function()
{
    var popupbutton = this;
    /*
	* mouse events
	*/
    this._button.mousedown(function () {
        var klass = $(this).attr('class');
        // MINUS BUTTON
        if (klass.indexOf("button1") !== -1) {
            var that = $(this);
            if (popupbutton._popupIntervalTimer !== 0) {
                clearInterval(popupbutton._popupIntervalTimer);
            }
            homeServerClient.sendTagValue(popupbutton._tag, popupbutton._getPopupElementNewValue(popupbutton._popupinterval_down));
            popupbutton._popupIntervalTimer = setTimeout(function () {
                popupbutton._checkTimeout(that, popupbutton._popupinterval_down);
            }, 800);
            return;
        }
        // PLUS BUTTON
        if (klass.indexOf("button2") !== -1) {
            var that = $(this);
            if (popupbutton._popupIntervalTimer !== 0) {
                clearInterval(popupbutton._popupIntervalTimer);
            }
            homeServerClient.sendTagValue(popupbutton._tag, popupbutton._getPopupElementNewValue(popupbutton._popupinterval_up));
            popupbutton._popupIntervalTimer = setTimeout(function () {
                popupbutton._checkTimeout(that, popupbutton._popupinterval_up);
            }, 800);
            return;
        }
    });

    this._button.mouseup(function () {
        var klass = $(this).attr('class');
        // OK BUTTON
        if (klass.indexOf("button-ok") !== -1) {
            closePopup();
            return;
        }
        clearInterval(popupbutton._popupIntervalTimer);
        popupbutton._popupInterval = 800;
    });

    this._button.mouseleave(function () {
        clearInterval(popupbutton._popupIntervalTimer);
        popupbutton._popupInterval = 800;
    });

    /*
	* touch events
	*/
    var buttonElement = this._button[0];
    buttonElement.ontouchstart = function () {
        var klass = $(this).attr('class');
        // MINUS BUTTON
        if (klass.indexOf("button1") !== -1) {
            var that = $(this);
            if (popupbutton._popupIntervalTimer !== 0) {
                clearInterval(popupbutton._popupIntervalTimer);
            }
            homeServerClient.sendTagValue(popupbutton._tag, popupbutton._getPopupElementNewValue(popupbutton._popupinterval_down));
            popupbutton._popupIntervalTimer = setTimeout(function () {
                popupbutton._checkTimeout(that, popupbutton._popupinterval_down);
            }, 800);
            return;
        }
        // PLUS BUTTON
        if (klass.indexOf("button2") !== -1) {
            var that = $(this);
            if (popupbutton._popupIntervalTimer !== 0) {
                clearInterval(popupbutton._popupIntervalTimer);
            }
            homeServerClient.sendTagValue(popupbutton._tag, popupbutton._getPopupElementNewValue(popupbutton._popupinterval_up));
            popupbutton._popupIntervalTimer = setTimeout(function () {
                popupbutton._checkTimeout(that, popupbutton._popupinterval_up);
            }, 800);
            return;
        }
    };

    buttonElement.ontouchend = function (e) {
        var klass = $(this).attr('class');
        // OK BUTTON
        if (klass.indexOf("button-ok") !== -1) {
            closePopup();
            return false;
        }
        clearInterval(popupbutton._popupIntervalTimer);
        popupbutton._popupInterval = 800;
    };

    buttonElement.ontouchcancel = function () {
        clearInterval(popupbutton._popupIntervalTimer);
        popupbutton._popupInterval = 800;
    };
}
;

/**
 * Calculates the new Value to send to the Homeserver
 * @param {int} direction if the new value is minus the skip or plus the skip
 * @return {string} new Value to send to the Homeserver
 * @private
 */
PopupButton.prototype._getPopupElementNewValue = function(direction) {

    var newvalue;
    var parent = _findElement(this._valueCssPath);
    // generated array 0 == number; 1 == ''
    var oldvalue = parent.text().split('%');

    //down
    if (direction === 1)
    {
        newvalue = parseFloat(oldvalue[0]) - parseFloat(this._skip);
        if (newvalue <= parseFloat(this._min))
        {
            newvalue = parseFloat(this._min);
        }
    }
    //up
    else if (direction === 2)
    {
        newvalue = parseFloat(oldvalue[0]) + parseFloat(this._skip);
        if (newvalue >= parseFloat(this._max))
        {
            newvalue = parseFloat(this._max);
        }
    }

    return newvalue;
}
;

function PopupSlider(sliderId, orient, min, max, tag, valueInvert, uisliderbackground, uisliderorientationbackground, uisliderhandlebackground) {

    var popupslider = this;
    this._sliderId = sliderId;
    this._valueInvert = valueInvert;
    this._min = min;
    this._max = max;

    $("#" + this._sliderId).slider({
        orientation: orient,
        range: "max",
        min: min,
        max: max,
        value: 50,
        stop: function(event, ui) {
            if (popupslider._valueInvert === true)
                homeServerClient.sendTagValue(tag, popupslider._max - ui.value);
            else
                homeServerClient.sendTagValue(tag, ui.value);
        }
    });
    /*
     * prepends the slider background AFTER the parend element
     */
    $("#" + this._sliderId).prepend("<div class='ui-slider-" + orient + " ui-slider-background'></div>");

    /*
     * wraps a div around the handle to set the size
     */
    $("#" + this._sliderId + " > .ui-slider-handle").wrap("<div class='ui-slider-vertical ui-slider-handle-range-size'></div>");
    $(".ui-slider-background").addClass(uisliderbackground).addClass("sprites");
    $(".ui-slider-" + orient).addClass(uisliderorientationbackground).addClass("sprites");
    $(".ui-slider-handle").addClass(uisliderhandlebackground).addClass("sprites");
}
;

PopupSlider.prototype.setSliderValue = function(value) {
    if (this._valueInvert === true)
        $("#" + this._sliderId).slider('value', this._max - parseInt(value));
    else
        $("#" + this._sliderId).slider('value', parseInt(value));
}
;

PopupSlider.prototype.setRange = function(range) {
    $("#" + this._sliderId).slider('option', 'range', range);
}
;