﻿var Coverflip = {
    coverflipStatus : {},
    isFlipped : function (id) {
        return Boolean(Coverflip.coverflipStatus[id]);
    },
    setFlipped: function (id, status) {
        Coverflip.coverflipStatus[id] = status;
    }
};
/* 
This function flips the coverflip sides from front-side to back-side.
Please note that the class hierarchy must as described below:
coverflip-container > coverflip-viewsides > coverflip-side (front/back)
*/
function coverflipFrontToBack(id, remove) {
    if (Coverflip.isFlipped(id)) return;
    Coverflip.setFlipped(id, true);
    var navbarController = NavbarController.getInstance();
    navbarController._disableViewButton();
    navbarController._addUnclickableOverlay();
   
    var $id = $(id);
	$id.parents('.swiper-wrapper').addClass('noSwipingH');
    $id.find('.coverflip-container').addClass('flip-animation');
    $('#pageContent .bulletbar').addClass('flip-animation');
    $id.find('.coverflip-viewsides')
      .on('webkitTransitionEnd', function () {
          navbarController.addBackFunction(function() {
              coverflipBackToFront(id, remove);
          });
          navbarController._removeUnclickableOverlay();

          $(this).off('webkitTransitionEnd');
      })
      .addClass('flipped');
    $('.bulletbar').on('webkitTransitionEnd', function () {
        $(this).off('webkitTransitionEnd');
    }).addClass('flipped');
}


/*
Remove all temporary coverflip classes used for animation purposes
*/
function resetCoverflip() {

	for (e in Coverflip.coverflipStatus)
	{			
		if(Coverflip.isFlipped(e) === false) continue;
		
		Coverflip.setFlipped(e, false);
		var $id = $(e);

		$id.parents('.swiper-wrapper').removeClass('noSwipingH');
		$id.find('.coverflip-container').removeClass('flip-animation');
		$('#pageContent .bulletbar').removeClass('flip-animation');
		$id.find('.coverflip-viewsides').removeClass('flipped');
		$id.find('.coverflip-side.back').remove();

		$('.bulletbar').removeClass('flipped');
	}
}

/*
This function flips the coverflip sides from back-side to front-side.
Please note that the class hierarchy must as described below:
coverflip-container > coverflip-viewsides > coverflip-side (front/back)
*/
function coverflipBackToFront(id, remove) {
    if (!Coverflip.isFlipped(id)) return;
    Coverflip.setFlipped(id, false);
    var navbarController = NavbarController.getInstance();
    navbarController._addUnclickableOverlay();
    var $id = $(id);
	$id.parents('.swiper-wrapper').removeClass('noSwipingH');
    $id.find('.coverflip-viewsides').on('webkitTransitionEnd', function() {
        navbarController._enableViewButton();
        $id.find('.coverflip-container').removeClass('flip-animation');
        $('#pageContent .bulletbar').removeClass('flip-animation');
        if (remove) {
            $id.find('.coverflip-side.back').remove();
        }
    
        navbarController._removeUnclickableOverlay();

        $(this).off('webkitTransitionEnd');

    }).removeClass('flipped');
    $('.bulletbar').on('webkitTransitionEnd', function() {
        $(this).off('webkitTransitionEnd');
    }).removeClass('flipped');
}
