/*jslint browser: true*/
/*global ko, $*/
(function (ns) {
    "use strict";
    ns.I18n = {
        init: function (keyedTexts, namespace) {
            var I18n = keyedTexts,
                Log = window.Gira.Log,
                setText = function (valueAccessor, setter) {
                    try {
                        var key = ko.unwrap(valueAccessor()),
                            text = I18n[key];
                        text = text || "no translation";
                        setter(text);
                    } catch (e) {
                        Log.exception(e);
                    }
                };
            ko.bindingHandlers[namespace + 'I18n'] = {
                init: function (element, valueAccessor) {
                    setText(valueAccessor, function (text) { $(element).html(text); });
                }
            };
            ko.bindingHandlers[namespace + 'I18nPlaceholder'] = {
                init: function (element, valueAccessor) {
                    setText(valueAccessor, function (text) { $(element).attr("placeholder", text); });
                }
            };
        }
    };
}(window.Gira));

