/*jslint browser: true*/
/*global ko, $, */

(function (ns) {
    "use strict";
    var Messages = window.Gira.DCS.Messages;

    function DoorCalls(saveCallbackFunc, config) {
        var saveCallback = saveCallbackFunc,
            doorCalls = ko.observableArray(),
            selectedDoorCall = ko.observable();

        function DoorCallItem(theKey, label, initialRingTone, currentIndex, allRingTones) {
            var selectedRingTone = ko.observable(initialRingTone),
                key = theKey;

            selectedRingTone.subscribe(function (value) {
                saveCallback([Messages.setMenuValue.playRingTone(value)], false);
            });

            return {
                key: key,
                label: label,
                index: currentIndex,
                ringTones: allRingTones,
                selectedRingTone: selectedRingTone,
                ok: function () {
                    saveCallback([Messages.setMenuValue.doorCall("Ringtone_" + key, selectedRingTone())], false);
                },
                title: config.title
            };
        }

        return {
            init: function (allDoorCalls, allRingTones) {
                doorCalls.removeAll();
                allDoorCalls.forEach(function (item, index) {
                    doorCalls.push(new DoorCallItem(item.keyIndex, item.value, item.ringTone, index, allRingTones));
                });
            },
            doorCalls: doorCalls,
            getSelectedDoorCall: function () {
                return selectedDoorCall();
            },
            selectedDoorCall: selectedDoorCall,
            isVisible: ko.observable(false),
            label: config.label
        };
    }

    ns.DoorCalls = DoorCalls;
}(window.Gira.DCS));

//# sourceURL=dcs.settings.doorCalls.js
