/*jslint browser: true*/
/*global ko,  $, _*/

(function (ns) {
    "use strict";
    var Messages = window.Gira.DCS.Messages,
        Urns = window.Gira.DCS.Urns,
        resolvedItems = [],
        connection,
        messagesToSend = [Messages.getIdFromName(Urns.connectChannel)],
        areAllResolved = false;

    function addResolvedItem(key, value) {
        var item = { key: key, value: value };
        if (_.find(resolvedItems, function (item) { return item.key === key; }) === undefined) {
            resolvedItems.push(item);
        }
    }

    function sendMessages() {
        if (resolvedItems.length !== messagesToSend.length) {
            messagesToSend.forEach(function (item) {
                connection.sendMessage(item);
            });
        }
    }

    function unRegisterWhenReceivedAllResponses() {
        if (resolvedItems.length === messagesToSend.length) {
            areAllResolved = true;
        }
    }

    ns.ResolvedUrns = {
        init: function (gdsConnection) {
            connection = gdsConnection;
        },
        onOpen: function () {
            sendMessages();
        },
        applyData: function (obj) {
            addResolvedItem(obj.request.urn, obj.response.id);
            unRegisterWhenReceivedAllResponses();
        },
        get: function (urn) {
            var item = _.find(resolvedItems, function (item) { return item.key === urn; });
            return item !== undefined ? item.value : undefined;
        },
        areUrnsResolved: function () { return areAllResolved; }
    };
}(window.Gira.DCS));

//@ sourceURL=dcs.resolvedUrns.js