/*jslint browser: true*/
(function (ns) {
    "use strict";
    var Urns = window.Gira.DCS.Urns,
        isCameraIcon = function (event) {
            return event.urn === Urns.camera + ":Icon";
        };
    ns.DoorCall = {
        canAcceptRecall: function (event) {
            return Urns.isRecallCall(event);
        },
        hasAcceptedCall: function (event) {
            return Urns.isActiveDoorCall(event);
        },
        isCallArriving: function (event) {
            return Urns.isIncomingDoorCall(event);
        },
        isCallInactive: function (event) {
            return Urns.isDoorCallIdle(event);
        },
        isHangUpSelected: function (event) {
            return Urns.isDisplayMainWithValue(event, Urns.displayMessages.recall, Urns.displayMessages.activeDoorCall)
                || Urns.isDisplayMainWithValue(event, Urns.displayMessages.idle, Urns.displayMessages.activeDoorCall);
        },
        isOutgoingCallInitiated: function (event) {
            return Urns.isOutgoingDoorStationCall(event);
        },
        isCameraCloseByUser: function (event) {
            return isCameraIcon(event) && event.value === "3" && event.oldValue === "6";
        }
    };
}(window.Gira.DCS));
