#!/bin/bash

DEFAULT_DIR="/opt/gira/default/userdata"
USERDATA_DIR="/opt/userdata"

# In conjunction with the factory reset the timeout time of 60s might not
# be enough. Triggering on start) entry and exit gives 60s of time for copying
# stuff to userdata wich should be sufficient and restricts the module to only bark
# two times.
case "$1" in
  start)
    echo Z > /dev/watchdog
    cd ${DEFAULT_DIR}
    find -type d -exec mkdir -p "${USERDATA_DIR}/{}" \;
    while read line
    do
      if [ ! -f "${USERDATA_DIR}/$line" ]
      then
        cp -p "${DEFAULT_DIR}/$line" "${USERDATA_DIR}/$line"
      fi
    done < <(find -type f)
    echo Z > /dev/watchdog
    ;;
  stop)
    ;;
  *)
    echo "Usage: $0 {start|stop}" >&2
    exit 1
    ;;
esac

exit 0
