#!/bin/sh

#
# Script to check for the connected G1 power source.
# If eth0 has a carrier detected it is assumed a POE power source is connected.
# In this case the ethernet phy is chosen as net device and the WiFi will be disabled.
# Else it is assumed a 230V or a 24V power source is connected.
# In that case the ethernet phy will be shut down and the WLAN module
# will be active.
# As the kernel is required to have brought up the devices this script loops for an amount of IDENTI_TRIES
# to check if eth0 has a carrier.
# Returns ERR_NO_NET_DEVICE if neither eth0 nor wlan0 could be identified.
#

# If eth0 has a carrrier this will be the line count for wc.
HAS_CARRIER=0
# Set eth0 to have no carrier initially.
ETH0_CARRIER=1
# Try this often to check eth0 for a valid carrier.
IDENTI_TRIES=500
# If neither eth0 nor wlan0 could be identified this script will return this value.
ERR_NO_NET_DEVICE=1

if [ "$(ip link show | grep 'eth0' | cut -d ':' -f 2 | tr -d '\040\011\012\015')" = "eth0" ]
then
  echo "[identify-power-source.sh] eth0 device found. Check for carrier."
  for i in `seq 1 ${IDENTI_TRIES}`
  do
    ETH0_CARRIER=$(/sbin/ip link show | grep 'eth0' | grep 'NO-CARRIER' | wc -l)
#    echo "[identify-power-source.sh] ETH0_CARRIER(${i}): ${ETH0_CARRIER}"
    if [ ${ETH0_CARRIER} -eq ${HAS_CARRIER} ]
    then
      break;
    fi
  done
else
if [ "$(ip link show | grep 'wlan0' | cut -d ':' -f 2 | tr -d '\040\011\012\015')" = "wlan0" ]
then
  echo "[identify-power-source.sh] Net device eth0 not found. Activating wlan0."
  /etc/init.d/ethernet.sh disable
  /usr/bin/connmanctl enable wifi
  exit 0
else
  echo "[identify-power-source.sh] Failed to identify net devices. Neither eth0 nor wlan0 could be found!"
  exit ${ERR_NO_NET_DEVICE}
fi
fi

if [ ${ETH0_CARRIER} -eq ${HAS_CARRIER} ]
then
  echo "[identify-power-source.sh] POE recognized as connected! WLAN will be deactivated."
  /usr/bin/connmanctl disable wifi
else
  echo "[identify-power-source.sh] POE not recognized as connected! Ethernet PHY will be deactivated."
  /etc/init.d/ethernet.sh disable
  /usr/bin/connmanctl enable wifi
fi

exit 0
