#!/bin/sh

print_usage()
{
  echo "Usage:"
  echo "exchange-bootloader.sh device bootloaderfile"
  echo "e.g. : exchange-bootloader.sh /dev/mmcblk0 u-boot-imx6sgc4.imx"
}


target_device=$1
bootloader_file=$2


if [ "$target_device" = "" -o "$bootloader_file" = "" ] 
then
  echo "not enough arguments"
  print_usage
  exit 1
fi

if [ ! -e $target_device ]
then
  echo "target device does not exist"
  exit 1
fi

if [ ! "`ls -lLa $target_device| cut -b 0-1`" = "b" ]
then
  echo "target device is no block device"
  exit 1
fi

if [ ! "`echo $target_device| cut -b 0-4`" = "/dev" ]
then
  echo "target device is not in /dev"
  exit 1
fi

if [ ! -e $bootloader_file ]
then
  echo "bootloader file does not exist"
  exit 1
fi





filesize=`ls -l $bootloader_file | awk '{ print $5 }'`
installed_checksum=`dd if=$target_device  bs=1 count=$filesize  skip=1024 | md5sum | cut -d " " -f1`
bootloader_checksum=`md5sum $bootloader_file | cut -d " " -f1`

echo "installed checksum: $installed_checksum"
echo "bootloader checksum: $bootloader_checksum"

if [ "$installed_checksum" = "$bootloader_checksum" ]
then
  echo "do not exchange bootloader"
else
  echo "exchange bootloader"
  dd if=$bootloader_file bs=1K seek=1 of=$target_device
  echo "bootloader exchanged"
fi
