<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:output indent="yes" method="html"/>

  <xsl:template name="addDataBindAttribute">
    <xsl:if test="@data-bind">
      <xsl:attribute name="data-bind">
        <xsl:value-of select="@data-bind"/>
      </xsl:attribute>
    </xsl:if>
  </xsl:template>

  <!--
    This template create the bulletbar and its bullet html elements
    The max number of bullets is limited to 25 bullets.
    
    params:
        srcElements
        This collection is used to loop over. It's count defines the number of bullets created.
        (because xslt v1.0 does not support for loops)
    
    Usage:
        <xsl:call-template name="bulletbar">
            <xsl:with-param name="srcElements" select="TopView/*"/>        
        </xsl:call-template>                    
    -->
  <xsl:template name="bulletbar">
    <xsl:param name="srcElements"/>

    <div class="bulletbar">
      <xsl:if test="count($srcElements) = 1">
        <div class="bullets last inactive sprites {{{{bullets-inactive}}}}"></div>
      </xsl:if>

      <xsl:if test="count($srcElements) > 1">
        <div class="bullets first inactive sprites {{{{bullets-inactive}}}}"></div>
        <xsl:if test="count($srcElements) > 2">
          <xsl:for-each select="($srcElements)[position() &lt;=count($srcElements)-2 and position() &lt;=23 ]">
            <div class="bullets middle inactive sprites {{{{bullets-inactive}}}}"></div>
          </xsl:for-each>
        </xsl:if>
        <div class="bullets last inactive sprites {{{{bullets-inactive}}}}"></div>
      </xsl:if>
    </div>
  </xsl:template>

  <!--
    Create the detail description row element for detail views
    -->
  <xsl:template name="channel_detail_description_row">
    <div id="description-row" class="description-row" style="display: none;">
      <div class="function-name t1sw">
        <xsl:value-of select="@function" />
        <xsl:value-of select="Channel/Description/Language[@Index = 0]" />
      </div>
      <div class="room-name t1gw">
        <xsl:value-of select="Channel/ContainerDescription/Language[@Index = 0]" />
      </div>
      <xsl:if test="Channel/FunctionSymbol/@Enable = 'true'">
        <div class="function-icon">
          <xsl:attribute name="class">
            function-icon sprites {{<xsl:value-of select="Channel/@ContainerIndex" />-<xsl:value-of select="Channel/@Index" />-detail-functionsymbol}}
          </xsl:attribute>
        </div>
      </xsl:if>
    </div>
  </xsl:template>
  <!--
    Create the detail description row element for container detail views
    -->
  <xsl:template name="container_detail_description_row">
    <div id="description-row" class="description-row" style="display: none;">
      <div class="function-name t1sw">
        <xsl:value-of select="Container/Description/Language[@Index = 0]" />
      </div>
      <div class="room-name t3gw">{{langFunctionFolderTile}}</div>
      <xsl:if test="Container/Symbol/@Enable = 'true'">
        <div class="function-icon">
          <xsl:attribute name="class">
            function-icon sprites {{top-<xsl:value-of select="Container/@Index" />-detail-functionsymbol}}
          </xsl:attribute>
        </div>
      </xsl:if>
    </div>
  </xsl:template>

  <xsl:template name="gt">
    <xsl:text disable-output-escaping="yes">&gt;</xsl:text>
  </xsl:template>

  <xsl:template name="lt">
    <xsl:text disable-output-escaping="yes">&lt;</xsl:text>
  </xsl:template>

  <!--
    Creates the tile toggle switch button for the tile views
  -->
  <xsl:template name="toggleSwitchButton">
    <xsl:param name="Id" />
    <xsl:param name="ColorIdLeft" />
    <xsl:param name="ColorIdRight" />
    <xsl:param name="ColorPicker" />
    <div class="onoffswitch">
      <input type="checkbox" name="onoffswitch" class="onoffswitch-checkbox">
        <xsl:attribute name="id">
          <xsl:value-of select="$Id" />
        </xsl:attribute>
        <xsl:call-template name="addDataBindAttribute"></xsl:call-template>
      </input>
      <label class="onoffswitch-label" for="myonoffswitch">
        <xsl:attribute name="for">
          <xsl:value-of select="$Id" />
        </xsl:attribute>
        <div class="onoffswitch-inner-wrapper">
          <div class="onoffswitch-inner">
            <div>
              <xsl:attribute name="class">
                <xsl:text>slider-background-left t2ws led-color-</xsl:text>
                <xsl:value-of select="$ColorIdLeft"/>
              </xsl:attribute>
              <xsl:choose>
                <xsl:when test="$ColorPicker='true'">
                  <div class="slider-on-icon onoffswitch-icon-shadow-1"></div>
                </xsl:when>
                <xsl:otherwise>
                  <div class="slider-on-icon onoffswitch-icon-shadow-0"></div>
                </xsl:otherwise>
              </xsl:choose>
            </div>
            <div>
              <xsl:attribute name="class">
                <xsl:text>slider-background-right t2ws led-color-</xsl:text>
                <xsl:value-of select="$ColorIdRight"/>
              </xsl:attribute>
              <div class="slider-off-icon onoffswitch-icon-shadow-0"></div>
            </div>
          </div>
        </div>
        <div class="onoffswitch-mask"></div>
        <div class="onoffswitch-switch sliderbutton-bg">
          <div class="sliderbutton-fg"></div>
        </div>
      </label>
      <div class="toggleslider-inactiveoverlay"/>
    </div>
  </xsl:template>

  <!--
    Creates the tile up/down arrow buttons for the tile views
    -->
  <xsl:template name="tileUpDownButtons">
    <xsl:param name="Index" />
    <div class="buttongroup">
      <div class="arrow-down button-left sliderbutton-bg">
        <xsl:attribute name="id">
          <xsl:text>arrowdown-</xsl:text><xsl:value-of select="Channel/@ContainerIndex" />-<xsl:value-of select="$Index"/>
        </xsl:attribute>
        <div class="sliderbutton-fg"></div>
        <div class="sliderbutton-label sprites {{{{tile-arrow-down}}}}" enabled="{{{{tile-arrow-down}}}}" inactive="{{{{tile-arrow-down-inactive}}}}"></div>
      </div>
      <div class="arrow-up button-right sliderbutton-bg">
        <xsl:attribute name="id">
          <xsl:text>arrowup-</xsl:text><xsl:value-of select="Channel/@ContainerIndex" />-<xsl:value-of select="$Index"/>
        </xsl:attribute>
        <div class="sliderbutton-fg"></div>
        <div class="sliderbutton-label sprites {{{{tile-arrow-up}}}}" enabled="{{{{tile-arrow-up}}}}" inactive="{{{{tile-arrow-up-inactive}}}}"></div>
      </div>
    </div>
  </xsl:template>

  <!--
    Creates the tile I/O on-off buttons for the tile views
    -->
  <xsl:template name="tileOnOffButtons">
    <xsl:param name="Index" />
    <div class="buttongroup">
      <div class="tileButtonOff button-left sliderbutton-bg">
        <div class="sliderbutton-fg"></div>
        <div class="sliderbutton-label sprites {{{{label-button-off}}}}"></div>
      </div>
      <div class="tileButtonOn button-right sliderbutton-bg">
        <div class="sliderbutton-fg"></div>
        <div class="sliderbutton-label sprites {{{{label-button-on}}}}"></div>
      </div>
    </div>
  </xsl:template>

  <!--
    Creates the button for the trigger/switch tile views
    -->
  <xsl:template name="tileTriggerButton">
    <xsl:param name="Index" />
    <div class="trigger-button">
      <xsl:attribute name="id">
        <xsl:text>tile_trigger_button-</xsl:text><xsl:value-of select="Channel/@ContainerIndex" />-<xsl:value-of select="$Index"/>
      </xsl:attribute>
      <div class="tile-trigger-button sliderbutton-bg ">
        <div class="sliderbutton-fg"></div>
        <div class="sliderbutton-label sprites {{{{tile-trigger}}}}"></div>
      </div>
    </div>

  </xsl:template>

  <!--
    Creates the unique tile id name
    -->
  <xsl:template name="tileId">
    <xsl:text>tile-</xsl:text><xsl:value-of select="Channel/@ContainerIndex" />-<xsl:value-of select="Channel/@Index" />
  </xsl:template>


  <!--
    Creates the basic structure for blind and shutter absolute templates including movement symbol and stop button.
    
    params:
        sliders
        Html structure for the shutter or blind sliders including scala       
        
        valueLeft
        Show left status value display
        
        valueRight
        Show right status value display
    -->
  <xsl:template name="shutterBlindAbsolutLayout">
    <xsl:param name="sliders" />
    <xsl:param name="valueLeft" />
    <xsl:param name="valueRight" />
    <div class="coverflip-container">
      <div class="coverflip-viewsides">
        <div id="flip" class="coverflip-side front">
          <div class="blindabsolute">
            <xsl:if test="Channel/DataPoints/DataPoint/@TypeURN = 'de.gira.schema.datapoints.Movement'">
              <div class="movement_symbol"></div>
            </xsl:if>
            <xsl:if test="$valueLeft = 'true'">
              <div class="value left">
                <div class="value_text t1sg">-</div>
                <div class="value_unit t2gg">%</div>
              </div>
            </xsl:if>
            <xsl:copy-of select="$sliders"/>
            <xsl:if test="$valueRight = 'true'">
              <div class="value right">
                <div class="value_text t1sg">-</div>
                <div class="value_unit t2gg">%</div>
              </div>
            </xsl:if>
            <xsl:if test="Channel/DataPoints/DataPoint/@TypeURN = 'de.gira.schema.datapoints.StepUpDown'">
              <div class="stopBtn sliderbutton-bg">
                <div class="sliderbutton-fg"></div>
                <div class="sliderbutton-label sprites {{{{gc4_button_stop}}}}"></div>
              </div>
            </xsl:if>
            <div class="coverflip-background">
            </div>
            <xsl:if test="Channel/TimeSwitches/@Enable ='true'">
              <div class="timer-icon sprites {{{{gc4_button_timer}}}}"></div>
            </xsl:if>
          </div>
        </div>
      </div>
    </div>
  </xsl:template>

  <!--
    Creates the statusbar
    -->
  <xsl:template name="statusBar">
    <xsl:param name="invert"/>
    <div class="status-display">
      <div class="statusbar-icons">
        <div>

          <xsl:choose>
            <xsl:when test="$invert='true'">
              <xsl:attribute name="class">
                <xsl:text>system-configuration</xsl:text>
              </xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="class">
                <xsl:text>system-configuration t3sw</xsl:text>
              </xsl:attribute>
            </xsl:otherwise>
          </xsl:choose>


          <xsl:value-of select="//Temperature/DeviceBaseConfigDescription"/>
        </div>
        <div class="date status-element" data-bind="text: date">--/--/--</div>
        <div class="time status-element" data-bind="text: time">--:--</div>
          <xsl:if test="//Temperature/ShowRoomTemperature/@Enable='true'">
            <div class="status-element">
              <div class="temp-in-txt" data-bind="text: tempIn"></div>
              <xsl:choose>
                <xsl:when test="$invert='true'">
                  <div class="temp-in-icon sprites {{{{temp-in-icon-white}}}}"></div>
                </xsl:when>
                <xsl:otherwise>
                  <div class="temp-in-icon sprites {{{{temp-in-icon}}}}"></div>
                </xsl:otherwise>
              </xsl:choose>
            </div>
          </xsl:if>
          <xsl:if test="//Temperature/ShowOutdoorTemperature/@Enable='true'">
            <div class="status-element">
              <div class="temp-out-txt" data-bind="text: tempOut"></div>
              <xsl:choose>
                <xsl:when test="$invert='true'">
                  <div class="temp-out-icon sprites {{{{temp-out-icon-white}}}}"></div>
                </xsl:when>
                <xsl:otherwise>
                  <div class="temp-out-icon sprites {{{{temp-out-icon}}}}"></div>
                </xsl:otherwise>
              </xsl:choose>
            </div>
          </xsl:if>
        <div class="status-element-icons">
          <div id="status-alert-icon"  data-bind="visible: alert" class="sprites {{{{status-alert-icon}}}}"></div>
          <div id="status-doorautom-icon" data-bind="visible: doorautom" class="sprites {{{{status-doorautom-icon}}}}"></div>
        </div>
      </div>
    </div>
  </xsl:template>

  <!--
    Creates the slotmachine
    -->
  <xsl:template name="slotmachine">
    <xsl:param name="spinnWheelId" />
    <div class="valuator">
      <div class="slot-machine noSwipingV">
        <xsl:attribute name="id">
          <xsl:copy-of select="$spinnWheelId"/>
        </xsl:attribute>
      </div>
    </div>
  </xsl:template>

  <!--
    Creates rtc modes
    -->
  <xsl:template name="rtc_mode">
    <xsl:param name="rtcModeId" />
    <xsl:param name="rtcModeIcon" />
    <xsl:param name="rtcModeLabel" />
    <xsl:param name="extensionMode" />
    <xsl:variable name="mode-suffix">
      <xsl:choose>
        <xsl:when test="$extensionMode = 'true'">-singleline</xsl:when>
        <xsl:otherwise>-oneandhalfline</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <li>
      <xsl:attribute name="id">
        <xsl:copy-of select="$rtcModeId"/>
      </xsl:attribute>
      <xsl:attribute name="class">
        li<xsl:value-of select="$mode-suffix" />
      </xsl:attribute>
      <span>
        <xsl:attribute name="class">
          icon icon<xsl:value-of select="$mode-suffix" /> sprites {{<xsl:copy-of select="$rtcModeIcon"/>}}
        </xsl:attribute>
      </span>
      <span>
        <xsl:attribute name="class">
          <xsl:text>
            label label
          </xsl:text>
          <xsl:value-of select="$mode-suffix" />
          <xsl:text> t1sg</xsl:text> 
        </xsl:attribute>  
        <xsl:copy-of select="$rtcModeLabel"/>
      </span>
      <xsl:if test="$extensionMode!='true'">
        <span class="icon hot {{{{gc4_icon_heating_list}}}} sprites"></span>
        <span class="temp-hot t2sg"></span>
        <span class="icon seperator"></span>
        <span class="icon cold {{{{gc4_icon_cooling_list}}}} sprites"></span>
        <span class="temp-cold t2sg"></span>
      </xsl:if>
      <div>
        <xsl:attribute name="class">
          <xsl:text>timerFadeIn radio radio</xsl:text>
          <xsl:value-of select="$mode-suffix" />
        </xsl:attribute>
      </div>
      <span class="icon sprites {{{{tile-arrow-right}}}} arrow-right timerFadeOut"></span>
    </li>
  </xsl:template>

  <xsl:template name="rtc_mode_edit_temperarure">
    <xsl:param name="hotCold" />
    <xsl:param name="icon" />
    <xsl:param name="label" />
    <xsl:variable name="spinnWheelId">
      <xsl:text>rtr-edit-</xsl:text>
      <xsl:copy-of select="$hotCold"/>
      <xsl:text>-slotmachine</xsl:text>
    </xsl:variable>
    <div class ="edit-temperature-headline">
      <span>
        <xsl:attribute name="class">
          <xsl:text>icon sprites </xsl:text>
          <xsl:copy-of select="$hotCold"/>
          <xsl:text> {{</xsl:text>
          <xsl:copy-of select="$icon"/>
          <xsl:text>}}</xsl:text>
        </xsl:attribute>
      </span>
      <span>
        <xsl:attribute name="class">
          <xsl:text>t2sg temp-</xsl:text>
          <xsl:copy-of select="$hotCold"/>
        </xsl:attribute>
        <xsl:copy-of select="$label"/>
      </span>
    </div>
    <div class ="edit-temperature-selection">
      <xsl:call-template name="slotmachine">
        <xsl:with-param name="spinnWheelId">
          <xsl:copy-of select="$spinnWheelId"/>
        </xsl:with-param>
      </xsl:call-template>
      <div class="valuator">
        <div class="gradient-top CSS8a">
        </div>
        <div class="temp-double-line upper">
        </div>
        <div class="temp-double-line lower">
        </div>
        <div class="gradient-bottom CSS8b">
        </div>
        <xsl:if test="//Temperature/ShowUnits/@Enable='true'">
          <div class="t2gg unitLabel">
            <xsl:value-of select="//Temperature/ShowUnits"/>
          </div>
        </xsl:if>
      </div>
    </div>
    <script type="text/javascript">
      (function(){
      var wheelId = '<xsl:copy-of select="$spinnWheelId"/>';
      var dataset = document.getElementById('rtc-modes').dataset;
      RtcModes.initRtcModesSpinningWheel(wheelId, parseFloat(dataset.stepSize));
      })();
    </script>
  </xsl:template>

  <!-- RTC mode extension button -->
  <xsl:template name="rtc-mode-extension">
    <xsl:param name="detailId" />
    <div id="rtc-mode-extension-container-comfort" class="rtc-mode-extension-container">
      <div class="rtc-mode-extension-button"></div>
      <div class="rtc-mode-extension-img sprites {{{{gc4_rtr-button_comfortmode}}}}"></div>
    </div>
    <div id="rtc-mode-extension-container-presence" class="rtc-mode-extension-container">
      <div class="rtc-mode-extension-button"></div>
      <div class="rtc-mode-extension-img sprites {{{{gc4_rtr-button_presencemode}}}}"></div>
    </div>

    <script type="text/javascript">
      (function(){
      var detailId = '<xsl:copy-of select="$detailId" />';
      var dataset = document.getElementById(detailId).dataset;
      rtc.registerRtcModeExtensionButton('rtc-mode-extension-container-comfort', dataset.presenceId, '{{gc4_rtr-button_comfortmode}}', '{{gc4_rtr-button_comfortmode_active}}', '{{gc4_rtr-button_comfortmode_active}}');
      rtc.registerRtcModeExtensionButton('rtc-mode-extension-container-presence', dataset.presenceId, '{{gc4_rtr-button_presencemode}}', '{{gc4_rtr-button_presencemode_active}}', '{{gc4_rtr-button_presencemode_active}}');

      temporaryCaseSets.push(new CaseSet(dataset.presenceStatusId, CaseSetType.VALUE)
      .setOnValueFunction(function(value) {
      var buttonComfort = $('#rtc-mode-extension-container-comfort .rtc-mode-extension-button');
      var imageComfort = $('#rtc-mode-extension-container-comfort .rtc-mode-extension-img');
      var buttonPresence = $('#rtc-mode-extension-container-presence .rtc-mode-extension-button');
      var imagePresence = $('#rtc-mode-extension-container-presence .rtc-mode-extension-img')

      if(value == 1) {
      buttonComfort.addClass('active');
      imageComfort.removeClass('{{gc4_rtr-button_comfortmode}}');
      imageComfort.addClass('{{gc4_rtr-button_comfortmode_active}}');

      buttonPresence.addClass('active');
      imagePresence.removeClass('{{gc4_rtr-button_presencemode}}');
      imagePresence.addClass('{{gc4_rtr-button_presencemode_active}}');
      }
      else {
      buttonComfort.removeClass('active');
      imageComfort.addClass('{{gc4_rtr-button_comfortmode}}');
      imageComfort.removeClass('{{gc4_rtr-button_comfortmode_active}}');

      buttonPresence.removeClass('active');
      imagePresence.addClass('{{gc4_rtr-button_presencemode}}');
      imagePresence.removeClass('{{gc4_rtr-button_presencemode_active}}');
      }
      })
      );

      temporaryCaseSets.push(new CaseSet(dataset.showPresenceButtonInformationId, CaseSetType.VALUE)
      .setOnValueFunction(function(value) {
      if(value == 0) {
      $('#rtc-mode-extension-container-comfort').hide();
      $('#rtc-mode-extension-container-presence').hide();
      }
      else if(value == 1) {
      //temporary workaround: using a timeout to prevent the instant appearance of the button after the coverflip animation is finished
      setTimeout(function() { $('#rtc-mode-extension-container-comfort').hide() }, 1000);
      $('#rtc-mode-extension-container-presence').show();
      }
      else if(value == 2) {
      $('#rtc-mode-extension-container-comfort').show();
      //temporary workaround: using a timeout to prevent the instant appearance of the button after the coverflip animation is finished
      setTimeout(function() { $('#rtc-mode-extension-container-presence').hide(); }, 1000);
      }
      else {
      console.log("RTC mode extension button: unrecognized button-state value received: " + value);
      }
      })
      );
      })();

    </script>
  </xsl:template>

  <xsl:template name="shutterRelativeConfiguration">
    var config = {
    stepId: <xsl:value-of select="Channel/DataPoints/DataPoint[@Name='StepUpDown']/@Id"/>,
    moveId: <xsl:value-of select="Channel/DataPoints/DataPoint[@Name='MoveUpDown']/@Id"/>,
    stepMoveThreshold: <xsl:value-of select="Channel/StepMoveThreshold/@Value"/>,
    slatThreshold: <xsl:value-of select="Channel/SlatThreshold/@Value"/>,
    count: <xsl:value-of select="Channel/@count"/>,
    timerEnabled: <xsl:value-of select="Channel/TimeSwitches/@Enable"/>,
    connection: gds$
    };
  </xsl:template>
</xsl:stylesheet>