﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0">
    <xsl:import href="xsltemplates.xsl"/>
    <xsl:output indent="yes" />
    <xsl:output method="html"/>
    <xsl:template match="/">
      <div>
      <xsl:variable name="detailId">detail-<xsl:value-of select="Channel/@ContainerIndex" />-<xsl:value-of select="Channel/@Index" /></xsl:variable>
      <xsl:variable name="spinnWheelId">spinnWheel-<xsl:value-of select="Channel/@ContainerIndex" />-<xsl:value-of select="Channel/@Index" /></xsl:variable>
      <xsl:variable name="spinnWheelOkBtn"><xsl:value-of select="$spinnWheelId" />_OkBtn</xsl:variable>
      <xsl:variable name="isShowStatusValue" select="Channel/ShowStatusValue/@Enable" />
      <xsl:variable name="showUnits" select="Channel/ShowUnits" />
      <xsl:variable name="isShowUnitEnabled" select="Channel/ShowUnits/@Enable" />
      <xsl:variable name="statusValueId"><xsl:value-of select="$detailId" />_statusValue</xsl:variable>
      <xsl:call-template name="channel_detail_description_row"></xsl:call-template>
          
      <div class="detail">
        <xsl:attribute name="id">
          <xsl:copy-of select="$detailId"/>
        </xsl:attribute>
        
        <xsl:attribute name="data-transmit-id">
          <xsl:value-of select="Channel/DataPoints/DataPoint[@Index='0']/@Id"/>
        </xsl:attribute>
        <xsl:attribute name="data-status-id">
          <xsl:value-of select="Channel/DataPoints/DataPoint[@Index='1']/@Id" />
        </xsl:attribute>
        <xsl:attribute name="data-status-value-enabled">
          <xsl:value-of select="Channel/ShowStatusValue/@Enable" />
        </xsl:attribute>
        <xsl:attribute name="data-unit-value">
          <xsl:value-of select="Channel/ShowUnits"/>
        </xsl:attribute>
        <xsl:attribute name="data-unit-enabled">
          <xsl:value-of select="Channel/ShowUnits/@Enable"/>
        </xsl:attribute>
        <xsl:attribute name="data-scaling-info">
          <xsl:value-of select="Channel/@TypeURN = 'de.gira.schema.channels.ValueTransmitter2Byte'"/>
        </xsl:attribute>
        <xsl:attribute name="data-scaling-info-min">
          <xsl:value-of select="Channel/ScalingInfo/@Min"/>
        </xsl:attribute>
        <xsl:attribute name="data-scaling-info-max">
          <xsl:value-of select="Channel/ScalingInfo/@Max"/>
        </xsl:attribute>
        <xsl:attribute name="data-channel-index">
          <xsl:value-of select="Channel/@Index"/>
        </xsl:attribute>
        <xsl:attribute name="data-container-index">
          <xsl:value-of select="Channel/@ContainerIndex"/>
        </xsl:attribute>
        <xsl:attribute name="data-basis-value">
          <xsl:value-of select="Channel/BasisValue/@Value"/>
        </xsl:attribute>
        <xsl:attribute name="data-value-increment-enabled">
          <xsl:value-of select="Channel/ValueAdjustment/@Enable"/>
        </xsl:attribute>
        <xsl:attribute name="data-value-increment">
          <xsl:value-of select="Channel/ValueAdjustment/@IncrementValue"/>
        </xsl:attribute>
        <xsl:attribute name="data-precision">
          <xsl:value-of select="Channel/ScalingInfo/@Precision"/>
        </xsl:attribute>
        <xsl:attribute name="data-type">
          <xsl:value-of select="Channel/DataPoints/DataPoint[@Index='0']/@TypeURN"/>
        </xsl:attribute>
       
        <div class="statusValue t2sg">
            <xsl:attribute name="id">
              <xsl:value-of select="$statusValueId"/>
            </xsl:attribute>
              <xsl:if test="$isShowStatusValue = 'true'">
                <xsl:text>- - - </xsl:text><xsl:if test="$isShowUnitEnabled = 'true'"><xsl:value-of select="$showUnits" /></xsl:if>
            </xsl:if>
          </div>
        <xsl:call-template name="slotmachine">
          <xsl:with-param name="spinnWheelId" select="$spinnWheelId"/>
        </xsl:call-template>
        <div class="valuator">
        <div class="gradient-top CSS8a"></div>
        <div class="line upper"></div>
        <div class="line lower"></div>
        <div class="gradient-bottom CSS8b"></div>
        <div class="t2gg unitLabel">
          <xsl:if test="$isShowUnitEnabled = 'true'">
            <xsl:value-of select="$showUnits" />
          </xsl:if>
        </div>
        </div>
        <div class="btnOKvaluator CSSButton170"><xsl:attribute name="id"><xsl:value-of select="$spinnWheelOkBtn"/></xsl:attribute>{{valueTrasmitterOk}}</div>
      </div>
          
        <script type="text/javascript">
          (function(){
            var detailId = '<xsl:value-of select="$detailId" />'
            var dataset = document.getElementById(detailId).dataset;
            detailId = '#' + detailId;
            tsx.ValueTransmitter(detailId, dataset);
          })();
        </script>
      </div>
    </xsl:template>
</xsl:stylesheet>

