<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:output indent="yes" />
  <xsl:output method="html"/>
  <xsl:template match="/">
    .valuator .sw-wrapper {
    position:absolute;
    left:<xsl:value-of select="/metrics/detail/metric[@key = 'sw-wrapper']/left"/>;
    width:100%;
    height:inherit;
    text-align:left;
    -webkit-transform: translateZ(0);
    }

    .valuator .sw-pressed { opacity:0.4; }

    .valuator .sw-slots-wrapper {
    position:relative;
    z-index:<xsl:value-of select="/metrics/detail/metric[@key = 'sw-slots-wrapper']/z-index"/>;
    display:block;
    height:inherit;
    overflow:hidden;
    }

    .valuator .sw-slots {
    position:absolute;
    display:table-cell;
    height:100%;
    padding-top:<xsl:value-of select="/metrics/detail/metric[@key = 'sw-slots-div']/padding-top"/>px;
    font-size: <xsl:value-of select="/metrics/detail/metric[@key = 'sw-slots-div']/font-size"/>px;
    line-height: <xsl:value-of select="/metrics/detail/metric[@key = 'sw-slots-div']/line-height"/>px;
    right: <xsl:value-of select="/metrics/detail/metric[@key = 'sw-frame']/right"/>px;
    width: <xsl:value-of select="/metrics/detail/metric[@key = 'sw-frame']/width"/>px;
    }

    .valuator .sw-slots table, tr, td {
    width: 100%;
    margin: 0;
    padding: 0;
    border: 0;
    font-size: 100%;
    font: inherit;
    vertical-align: baseline;
    border-collapse: collapse;
    border-spacing: 0;
    text-align: right;
    color: #3c3c3c;
    }

    .valuator .sw-slots ul {
    padding:0 0 <xsl:value-of select="/metrics/detail/metric[@key = 'sw-slots-ul']/padding-bottom"/>px 0; margin:0;
    list-style:none;
    top: <xsl:value-of select="/metrics/detail/metric[@key = 'sw-slots-ul']/top"/>px;
    transition-timing-function:cubic-bezier(0, 0, 0.2, 1);
    text-align: center;
    }

    .valuator .sw-slots .sw-right { text-align:right; }
    .valuator .sw-slots .sw-shrink { width:1%; }
    .valuator .sw-slots .sw-readonly { background:#ddd; }

    .valuator .sw-slots li {
    padding:0 <xsl:value-of select="/metrics/detail/metric[@key = 'sw-slots-li']/padding-right"/>px;
    overflow:hidden;
    height: <xsl:value-of select="/metrics/detail/metric[@key = 'sw-slots-li']/height"/>px;
    position: relative;
    }

    .valuator .sw-frame {
    position:absolute;
    z-index:<xsl:value-of select="/metrics/detail/metric[@key = 'sw-frame']/z-index"/>;
    right: <xsl:value-of select="/metrics/detail/metric[@key = 'sw-frame']/right"/>px;
    width: <xsl:value-of select="/metrics/detail/metric[@key = 'sw-frame']/width"/>px;
    bottom:0;
    height:inherit;
    border-width:<xsl:value-of select="/metrics/detail/metric[@key = 'sw-frame']/border-width"/>px;
    }

    .valuator
    {
    width: inherit;
    height: inherit;
    position: absolute;
    }

    .valuator .slot-machine
    {
    position: relative;
    top: <xsl:value-of select="/metrics/detail/metric[@key = 'valuator-slot-machine']/top"/>px;
    height: <xsl:value-of select="/metrics/detail/metric[@key = 'valuator-slot-machine']/height"/>px;
    overflow: hidden;
    margin-left: auto;
    margin-right: auto;
    }
    .valuator .slots
    {
    top: <xsl:value-of select="/metrics/detail/metric[@key = 'valuator-slots']/top"/>px;
    position: relative;
    }

    .valuator .touchArea
    {
    position: absolute;
    top: <xsl:value-of select="/metrics/detail/metric[@key = 'valuator-touchArea']/top"/>px;
    left: <xsl:value-of select="/metrics/detail/metric[@key = 'valuator-touchArea']/left"/>px;
    height: <xsl:value-of select="/metrics/detail/metric[@key = 'valuator-touchArea']/height"/>px;
    width: <xsl:value-of select="/metrics/detail/metric[@key = 'valuator-touchArea']/width"/>px;
    }

    .valuator .line
    {
    border-top:1px solid #c8c8c8;
    border-bottom:1px solid #ffffff;
    width: <xsl:value-of select="/metrics/detail/metric[@key = 'valuator-line']/width"/>px;
    }

    .valuator .line.upper
    {
    top: <xsl:value-of select="/metrics/detail/metric[@key = 'valuator-line-upper']/top"/>px;
    left: <xsl:value-of select="/metrics/detail/metric[@key = 'valuator-line-upper']/left"/>;
    position: absolute;
    }

    .valuator .line.lower
    {
    top: <xsl:value-of select="/metrics/detail/metric[@key = 'valuator-line-lower']/top"/>px;
    left: <xsl:value-of select="/metrics/detail/metric[@key = 'valuator-line-lower']/left"/>;
    position: absolute;
    }

    .btnOKvaluator
    {
    position: absolute;
    top: <xsl:value-of select="/metrics/detail/metric[@key = 'valuator-btnOK']/top"/>px;
    left: <xsl:value-of select="/metrics/detail/metric[@key = 'valuator-btnOK']/left"/>px;
    }

    .valuator .unitLabel
    {
    position: absolute;
    top: <xsl:value-of select="/metrics/detail/metric[@key = 'valuator-unitLabel']/top"/>px;
    right: <xsl:value-of select="/metrics/detail/metric[@key = 'valuator-unitLabel']/right"/>px;
    text-align: right;
    line-height: <xsl:value-of select="/metrics/detail/metric[@key = 'valuator-unitLabel']/line-height"/>px;
    text-overflow: ellipsis;
    overflow: hidden;
    max-width: <xsl:value-of select="/metrics/detail/metric[@key = 'valuator-unitLabel']/max-width"/>px;
    }

    .valuator .floatingpoint{
    position:absolute;
    top:<xsl:value-of select="/metrics/detail/metric[@key = 'valuator-floatingpoint']/top"/>px;
    left:<xsl:value-of select="/metrics/detail/metric[@key = 'valuator-floatingpoint']/left"/>px;
    width:<xsl:value-of select="/metrics/detail/metric[@key = 'valuator-floatingpoint']/width"/>px;
    height:<xsl:value-of select="/metrics/detail/metric[@key = 'valuator-floatingpoint']/height"/>px;
    background-color: rgb(60,60,60);
    -webkit-box-shadow:0px 1px 0px 0px #ffffff;
    display:inline-block;
    }

    .valuator .CSS8a
    {
    background: -webkit-linear-gradient(top, rgba(245,245,245,1),rgba(245,245,245,0.65));
    }

    .valuator .CSS8b
    {
    background: -webkit-linear-gradient(bottom, rgba(245,245,245,1),rgba(245,245,245,0.65));
    }

    .gradient-top
    {
    position: absolute;
    top: <xsl:value-of select="/metrics/detail/metric[@key = 'gradient-top']/top"/>px;
    left: <xsl:value-of select="/metrics/detail/metric[@key = 'gradient-top']/left"/>px;
    width: inherit;
    height: <xsl:value-of select="/metrics/detail/metric[@key = 'gradient-top']/height"/>px;
    -webkit-transform: translateZ(0);
    }

    .gradient-bottom
    {
    position: absolute;
    top: <xsl:value-of select="/metrics/detail/metric[@key = 'gradient-bottom']/top"/>px;
    left: <xsl:value-of select="/metrics/detail/metric[@key = 'gradient-bottom']/left"/>px;
    width: inherit;
    height: <xsl:value-of select="/metrics/detail/metric[@key = 'gradient-bottom']/height"/>px;
    -webkit-transform: translateZ(0);
    }

    .statusValue{
    position: absolute;
    left: <xsl:value-of select="/metrics/detail/metric[@key = 'valuator-statusValue']/left"/>px;
    top: <xsl:value-of select="/metrics/detail/metric[@key = 'valuator-statusValue']/top"/>px;
    text-overflow: ellipsis;
    overflow: hidden;
    white-space: nowrap;
    width: <xsl:value-of select="/metrics/detail/metric[@key = 'valuator-statusValue']/width"/>px;
    }
  </xsl:template>
</xsl:stylesheet>
