﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">  
  <xsl:import href="xsltemplates.xsl"/>
  <xsl:output indent="yes" method="html"/> 
  <!-- key to select all details on the same container -->
  <xsl:key name="details-by-container" match="Filename[@id]" use="@id" />
  <xsl:template match="/">
      <div id="dcs-content-holder"></div>
      <script src="dcs/js/dcs.namespaces.js" type="text/javascript"></script>
      <script type="text/javascript">
          <!--console.log("reading fiiilee");-->
        var  translationManager = new window.Gira.LanguageManager(),
        I18nTexts = translationManager.register('dcs', 'dcs-lang.json'),
        states = {
                camera: {
                        "1": {
                              "icon": "{{{tks_icon_camera_inactive_off}}} dcs-button-normal",
                              "label": {
                                line1: I18nTexts["dcs.button.camera.label"],
                                line2: I18nTexts["dcs.button.camera.turnOn.label"]
                              },
                              default: true
                        },
                        "3": {
                              icon: '{{{tks_icon_camera_off}}} dcs-button-normal',
                              label: {
                                line1: I18nTexts["dcs.button.camera.label"],
                                line2: I18nTexts["dcs.button.camera.turnOn.label"]
                              }
                        },
                        "4": {
                              icon: '{{{tks_icon_camera_off_down}}} dcs-button-normal-down',
                              label: {
                                line1: I18nTexts["dcs.button.camera.label"],
                                line2: I18nTexts["dcs.button.camera.turnOn.label"]
                              }
                        },
                        "5": {
                              icon: '{{{tks_icon_camera}}} dcs-button-normal',
                              label: {
                                line1: I18nTexts["dcs.button.camera.label"],
                                line2: I18nTexts["dcs.button.camera.turnOff.label"]
                              }
                        },
                        "6": {
                              icon: '{{{tks_icon_camera_down}}} dcs-button-normal-down',
                              label: {
                                line1: I18nTexts["dcs.button.camera.label"],
                                line2: I18nTexts["dcs.button.camera.turnOff.label"]
                              }
                        }
                },
                ringTone: {
                        "30": {
                              icon: '{{{tks_icon_bell}}} dcs-button-normal',
                              label: {
                                line1: I18nTexts["dcs.button.ringTone.label"],
                                line2: I18nTexts["dcs.button.ringTone.turnOff.label"]
                              }
                        },
                        "31": {
                              icon: '{{{tks_icon_bell_down}}} dcs-button-normal-down',
                              label: {
                                line1: I18nTexts["dcs.button.ringTone.label"],
                                line2: I18nTexts["dcs.button.ringTone.turnOff.label"]
                              }
                        },
                        "32": {
                              icon: '{{{tks_icon_bell_off}}} dcs-button-normal',
                              label: {
                                line1: I18nTexts["dcs.button.ringTone.label"],
                                line2: I18nTexts["dcs.button.ringTone.turnOn.label"]
                              }
                        },
                        "33": {
                              icon: '{{{tks_icon_bell_off_down}}} dcs-button-normal-down',
                              label: {
                                line1: I18nTexts["dcs.button.ringTone.label"],
                                line2: I18nTexts["dcs.button.ringTone.turnOn.label"]
                              }
                        },
                        "34": {
                              icon: '{{{tks_icon_bell_inactive}}} dcs-button-normal',
                              label: {
                                line1: I18nTexts["dcs.button.ringTone.label"],
                                line2: I18nTexts["dcs.button.ringTone.turnOff.label"]
                              },
                              default: true
                        }
                },
                doorOpener: {
                        "40": {
                              icon: '{{{tks_icon_key}}} dcs-button-normal',
                              label: {
                                line1: I18nTexts["dcs.button.door.label"],
                                line2: I18nTexts["dcs.button.doorOpen.label"]
                              }
                        },
                        "41": {
                              icon: '{{{tks_icon_key_down}}} dcs-button-normal-down',
                              label: {
                                line1: I18nTexts["dcs.button.door.label"],
                                line2: I18nTexts["dcs.button.doorOpen.label"]
                              }
                        },
                        "43": {
                              icon: '{{{tks_icon_key}}} dcs-button-normal',
                              label: {
                                line1: I18nTexts["dcs.button.door.label"],
                                line2: I18nTexts["dcs.button.doorOpen.label"]
                              },
                              smallIcon: '{{{tks_icon_automatic_doorrelease_icon}}}'
                        },
                        "44": {
                              icon: '{{{tks_icon_key_down}}} dcs-button-normal-down',
                              label: {
                                line1: I18nTexts["dcs.button.door.label"],
                                line2: I18nTexts["dcs.button.doorOpen.label"]
                              },
                              smallIcon: '{{{tks_icon_automatic_doorrelease_icon}}}'
                        },
                        "45": {
                              icon: '{{{tks_icon_key_inactive}}} dcs-button-normal',
                              label: {
                                line1: I18nTexts["dcs.button.door.label"],
                                line2: I18nTexts["dcs.button.doorOpen.label"]
                              },
                              default: true
                        }
                },
                doorCall: {
                        "10": {
                              icon: '{{{tks_icon_door_call_inactive}}} dcs-button-normal',
                              label: {
                                line1: I18nTexts["dcs.button.doorCall.label"],
                                line2: I18nTexts["dcs.button.doorCall.accept.label"]
                              },
                              default: true
                        },
                        "11": {
                              icon: '{{{tks_icon_door_call_active}}} dcs-button-call-active',
                              label: {
                                line1: I18nTexts["dcs.button.doorCall.label"],
                                line2: I18nTexts["dcs.button.doorCall.accept.label"]
                              }
                        },
                        "12": {
                              icon: '{{{tks_icon_door_call_active_down}}} dcs-button-call-active-down',
                              label: {
                                line1: I18nTexts["dcs.button.doorCall.label"],
                                line2: I18nTexts["dcs.button.doorCall.accept.label"]
                              }
                        },
                        "13": {
                              icon: '{{{tks_icon_conversation_stop_active}}} dcs-button-call-stop',
                              label: {
                                line1: I18nTexts["dcs.button.doorCall.label"],
                                line2: I18nTexts["dcs.button.doorCall.end.label"]
                              }
                        },
                        "14": {
                              icon: '{{{tks_icon_conversation_stop_active_down}}} dcs-button-call-stop-down',
                              label: {
                                line1: I18nTexts["dcs.button.doorCall.label"],
                                line2: I18nTexts["dcs.button.doorCall.end.label"]
                              }
                        },
                        "15": {
                              icon: '{{{tks_icon_door_call_active}}} dcs-button-call-active',
                              label: {
                                line1: I18nTexts["dcs.button.doorCall.label"],
                                line2: I18nTexts["dcs.button.doorCall.acceptRecall.label"]
                              }
                        },
                        "16": {
                              icon: '{{{tks_icon_door_call_active_down}}} dcs-button-call-active-down',
                              label: {
                                line1: I18nTexts["dcs.button.doorCall.label"],
                                line2: I18nTexts["dcs.button.doorCall.acceptRecall.label"]
                              }
                        }
                },
                functionKeys: {
                    "0": {
                          icon: 'dcs-button-empty dcs-button-normal',
                          label: {
                            line1:  I18nTexts["dcs.button.function.noFunction.line1.label"],
                            line2:  I18nTexts["dcs.button.function.noFunction.line2.label"]
                          },
                          default: true
                    },
                    "50": {
                          icon: '{{{tks_icon_light}}} dcs-button-normal',
                          label: {
                            line1:  I18nTexts["dcs.button.function.lightSwitch.line1.label"],
                            line2:  I18nTexts["dcs.button.function.lightSwitch.line2.label"]
                          }
                    },
                    "51": {
                          icon: '{{{tks_icon_light_down}}} dcs-button-normal-down',
                          label: {
                            line1:  I18nTexts["dcs.button.function.lightSwitch.line1.label"],
                            line2:  I18nTexts["dcs.button.function.lightSwitch.line2.label"]
                          }
                    },
                    "55": {
                          icon: '{{{tks_icon_automatic_doorrelease}}} dcs-button-normal',
                          label: {
                            line1:  I18nTexts["dcs.button.function.autoDoorRelease.label"],
                            line2:  I18nTexts["dcs.button.function.autoDoorRelease.turnOn.line2.label"]
                          }
                    },
                    "56": {
                          icon: '{{{tks_icon_automatic_doorrelease_down}}} dcs-button-normal-down',
                          label: {
                            line1:  I18nTexts["dcs.button.function.autoDoorRelease.label"],
                            line2:  I18nTexts["dcs.button.function.autoDoorRelease.turnOn.line2.label"]
                          }
                    },
                    "57": {
                          icon: '{{{tks_icon_automatic_doorrelease_active}}} dcs-button-normal',
                          label: {
                            line1:  I18nTexts["dcs.button.function.autoDoorRelease.label"],
                            line2:  I18nTexts["dcs.button.function.autoDoorRelease.turnOff.line2.label"]
                          }
                    },
                    "58": {
                          icon: '{{{tks_icon_automatic_doorrelease_active_down}}} dcs-button-normal-down',
                          label: {
                            line1:  I18nTexts["dcs.button.function.autoDoorRelease.label"],
                            line2:  I18nTexts["dcs.button.function.autoDoorRelease.turnOff.line2.label"]
                          }
                    },
                    "60": {
                          icon: '{{{tks_icon_door_station_call}}} dcs-button-normal',
                          label: {line1: "", line2: ""}
                    },
                    "61": {
                          icon: '{{{tks_icon_door_station_call_down}}} dcs-button-normal-down',
                          label: {line1: "", line2: ""}
                    },
                    "65": {
                          icon: '{{{tks_icon_onoff}}} dcs-button-normal',
                          label: {line1: "", line2: ""
                          }
                    },
                    "66": {
                          icon: '{{{tks_icon_onoff_down}}} dcs-button-normal-down',
                          label: {line1: "", line2: ""}
                    }
                }
        };

        var notificationIcons = {
                "4": '{{{tks_popupicon_call}}} dcs-button-green-popup',
                "2": '{{{tks_popupicon_hangup}}} dcs-button-red-popup',
                "3": '{{{tks_popupicon_incomcall}}} dcs-button-normal-popup',
                "14": '{{{tks_popupicon_camera}}} dcs-button-normal-popup'
        };

        var pageOptions = {
            tileGridLine: '{{{tile-grid-line}}}',
            brandingTitle:  I18nTexts["pageOptions.brandingTitle"]
        };

        var settingsConfig = {
            connection: {
                  usernameEmptyMsg:  I18nTexts["settingsConfig.connection.usernameEmptyMsg"],
                  passwordEmptyMsg:  I18nTexts["settingsConfig.connection.passwordEmptyMsg"],
                  ipInvalidFormatMsg:  I18nTexts["settingsConfig.connection.ipInvalidFormatMsg"],
                  label:  I18nTexts["settingsConfig.connection.label"]
            },
            audio: {
                  microphone: {
                        infoText:  I18nTexts["settingsConfig.audio.microphone.infoText"],
                        label:  I18nTexts["settingsConfig.audio.microphone.label"],
                        maxIcon: '{{{tks_icon_microphone_max}}}',
                        minIcon: '{{{tks_icon_microphone_min}}}'
                  },
                  ringtone: {
                        infoText:  I18nTexts["settingsConfig.audio.ringtone.infoText"],
                        label:  I18nTexts["settingsConfig.audio.ringtone.label"],
                        maxIcon: '{{{tks_icon_volume_max}}}',
                        minIcon: '{{{tks_icon_volume_min}}}'
                  },
                  speaker: {
                        infoText:  I18nTexts["settingsConfig.audio.speaker.infoText"],
                        label:  I18nTexts["settingsConfig.audio.speaker.label"],
                        maxIcon: '{{{tks_icon_speech_max}}}',
                        minIcon: '{{{tks_icon_speech_min}}}'
                  }
            },
            automaticDoorOpener: {
              automaticDoorOpenerLabel:  I18nTexts["settingsConfig.automaticDoorOpener.label"]
            },
            cameras: {
              label:  I18nTexts["settingsConfig.cameras.label"]
            },
            doorStations: {
              label:  I18nTexts["settingsConfig.doorStations.label"]
            },
            doorCalls: {
              label:  I18nTexts["settingsConfig.doorCalls.label"],
              title:  I18nTexts["settingsConfig.doorCalls.title"]
            }
        };
        var connectionStateConfig = {
            wrongCredentialsMsg:  I18nTexts["connectionStateConfig.wrongCredentialsMsg"],
            licenseNumberExceededMsg:  I18nTexts["connectionStateConfig.licenseNumberExceededMsg"],
            timeoutMsg:  I18nTexts["connectionStateConfig.timeoutMsg"],
            internalErrorMsg:  I18nTexts["connectionStateConfig.internalErrorMsg"],
            connectionLostErrorMsg:  I18nTexts["connectionStateConfig.connectionLostErrorMsg"]
        };

        var displayChannelMainMessages = {
            "0": {
              "header":  I18nTexts["displayMain.message.standBy.header"],
              "text": ""
            },
            "1": {
              "header":  I18nTexts["displayMain.message.busy.header"],
              "text": ""
            },
            "2": {
              "header":  I18nTexts["displayMain.message.standBy.header"],
              "text": ""
            },
            "3": {
              "header":  I18nTexts["displayMain.message.incomingCall.header"],
              "text": ""
            },
            "4": {
              "header":  I18nTexts["displayMain.message.activeCall.header"],
              "text": ""
            },
            "5": {
              "header":  I18nTexts["displayMain.message.outgoingCall.header"],
              "text": ""
            },
            "6": {"header": "", "text": ""},
            "7": {"header": "", "text": ""},
            "8": {"header": "", "text": ""},
            "9": {"header": "", "text": ""},
            "10": {"header": "", "text": ""},
            "11": {
              "header":  I18nTexts["displayMain.message.noConnection.header"],
              "text":  I18nTexts["displayMain.message.noConnection.text"]
            },
            "12": {"header": "", "text": ""}
        };

        window.Gira.DCS.ButtonStates = states;
        window.Gira.DCS.NotificationIcons = notificationIcons;
        window.Gira.DCS.PageOption = pageOptions;
        window.Gira.DCS.SettingsConfig = settingsConfig;
        window.Gira.DCS.ConnectionStates = connectionStateConfig;
        window.Gira.DCS.DisplayMainMessages = displayChannelMainMessages;
        window.Gira.DCS.I18nTexts = I18nTexts;

        $('#dcs-content-holder').load("dcs/tks-main_view.html");
    </script>
  </xsl:template>
</xsl:stylesheet>