﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:import href="../xsltemplates.xsl"/>
  <xsl:import href="tile_structure.xsl"/>
  <xsl:output indent="yes" />
  <xsl:output method="html"/>
  <xsl:template match="/">
    <!-- set tileId variable -->
    <xsl:variable name="tileId">
      <xsl:call-template name="tileId"/>
    </xsl:variable>
    <div class="tile tile-small">
      <xsl:attribute name="id">
        <xsl:copy-of select="$tileId" />
      </xsl:attribute>
      <!-- generate tile structure-->
      <xsl:call-template name="tileContent">
        <xsl:with-param name="statusText">
          <div class="tile-function-folder-text t2gg">
            <xsl:value-of select="Channel/FunctionFolderText" />
          </div>
        </xsl:with-param>
        <xsl:with-param name="controlElements">
        </xsl:with-param>
        <xsl:with-param name="tileHeader">
        </xsl:with-param>
      </xsl:call-template>
      <script type="text/javascript">
        (function(){

        var tileId = '<xsl:value-of select="$tileId"/>';
        eventsOnTile(tileId);



        <!-- ######################### set tile click action ######################### -->
        $('#' + tileId).on('tileAction',function(){
        <xsl:choose>
          <xsl:when test="Channel/@TypeURN = 'de.gira.schema.channels.World'">
            <xsl:if test="Channel/@Index = 'tks'">
              if (window.Gira) {
              window.Gira.DCS.Controller.Tile.openTksView("templates/tks_view.xhtml", "#tile-view-top");
              }
            </xsl:if>
            <xsl:if test="Channel/@Index = 'weather'">
              if (window.Gira) {
              window.Gira.Weather.Controller.Tile.openView("templates/weather_view.xhtml", "#tile-view-top");
              }
            </xsl:if>
          </xsl:when>
        </xsl:choose>
        });
        })();
      </script>
    </div>
  </xsl:template>
</xsl:stylesheet>
