﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:output indent="yes" />
    <xsl:output method="html"/>
    <xsl:template match="/">
      .pf_body {
      background:rgba(0,0,0,0.85);
      width:<xsl:value-of select="/metrics/layout/metric[@key = 'layout.content']/width" />px;
      height:<xsl:value-of select="/metrics/layout/metric[@key = 'layout.content']/height" />px;
      position:absolute;
      z-index:100000000;
      left:0;
      top:0px;

      }
      .pf_description-row{
      text-align:center;
      position:relative;
      }
      .pf_detail{
        position: absolute;
        width: <xsl:value-of select="/metrics/primaryFunction/metric[@key = 'pf_detail']/width" />px;
        height: <xsl:value-of select="/metrics/primaryFunction/metric[@key = 'pf_detail']/height" />px;
        top: <xsl:value-of select="/metrics/primaryFunction/metric[@key = 'pf_detail']/top" />px;
        left: <xsl:value-of select="/metrics/primaryFunction/metric[@key = 'pf_detail']/left" />px;
      }
      .pf_backBtn {
      position: absolute;
      top: <xsl:value-of select="/metrics/primaryFunction/metric[@key = 'pf_backBtn']/top" />px;
      left: <xsl:value-of select="/metrics/primaryFunction/metric[@key = 'pf_backBtn']/left" />px;
      width:<xsl:value-of select="/metrics/primaryFunction/metric[@key = 'pf_backBtn']/width" />px; 
      height:34px;
      -webkit-border-radius: <xsl:value-of select="/metrics/primaryFunction/metric[@key = 'pf_backBtn']/radius" />px;
      border:1px solid #c8c8c8;
      background-color:transparent;
      display:inline-block;
      line-height:<xsl:value-of select="/metrics/primaryFunction/metric[@key = 'pf_backBtn']/line-height" />px !important;
      text-decoration:none;
      text-align:center;
      }
      .pf_backBtn:active {
      background-color:#c8c8c8;
      color:#000000;
      }
      .pf_function-name {
      position: absolute;
      text-align: center;
      width: <xsl:value-of select="/metrics/primaryFunction/metric[@key = 'pf_function-name']/width" />px;
      max-width: <xsl:value-of select="/metrics/primaryFunction/metric[@key = 'pf_function-name']/width" />px;
      top: <xsl:value-of select="/metrics/primaryFunction/metric[@key = 'pf_function-name']/top" />px;
      left: <xsl:value-of select="/metrics/primaryFunction/metric[@key = 'pf_function-name']/left" />px;
      text-overflow: ellipsis;
      overflow: hidden;
      white-space: nowrap;
      }
      .pf_room-name {
      position: absolute;
      text-align: center;
      width: <xsl:value-of select="/metrics/primaryFunction/metric[@key = 'pf_room-name']/width" />px;
      max-width: <xsl:value-of select="/metrics/primaryFunction/metric[@key = 'pf_room-name']/width" />px;
      top: <xsl:value-of select="/metrics/primaryFunction/metric[@key = 'pf_room-name']/top" />px;
      left: <xsl:value-of select="/metrics/primaryFunction/metric[@key = 'pf_room-name']/left" />px;
      text-overflow: ellipsis;
      overflow: hidden;
      white-space: nowrap;
      }

      .primary-button {
      position: absolute;
      left: <xsl:value-of select="/metrics/primaryFunction/metric[@key = 'primary-function-button']/left" />px; 
        top: <xsl:value-of select="/metrics/primaryFunction/metric[@key = 'primary-function-button']/top" />px; 
        display:inline-block;
        width: <xsl:value-of select="/metrics/primaryFunction/metric[@key = 'primary-function-button']/width" />px;
        height: <xsl:value-of select="/metrics/primaryFunction/metric[@key = 'primary-function-button']/height" />px;
        z-index: 2;
        border: 1px solid rgba(0,0,0,0.5);
        border-radius: 50%;
        background: -webkit-linear-gradient(top, rgba(80,80,80,0.9) 0%,rgba(90,90,90,0.9) 100%);
        -webkit-filter: drop-shadow(0px 2px 3px rgba(0,0,0,0.75));
      }

      .primary-button-down {
        position: absolute;
        left: <xsl:value-of select="/metrics/primaryFunction/metric[@key = 'primary-function-button-down']/left" />px; 
        top: <xsl:value-of select="/metrics/primaryFunction/metric[@key = 'primary-function-button-down']/top" />px;       
        display:inline-block;
        width: <xsl:value-of select="/metrics/primaryFunction/metric[@key = 'primary-function-button-down']/width" />px;
        height: <xsl:value-of select="/metrics/primaryFunction/metric[@key = 'primary-function-button-down']/height" />px;
        border: 0px solid rgba(0,0,0,0.5);
        z-index: 2;
        border-radius: 50%;
        background: -webkit-linear-gradient(top, rgba(90,90,90,1) 0%,rgba(90,90,90,1) 100%);
        -webkit-filter:none;
        -webkit-box-shadow:inset 0 0 6px 0px rgba(0,0,0,0.75);
      }

    </xsl:template>
</xsl:stylesheet>