/*global ko, $, gds$, _*/
/*jslint browser: true*/
(function (ns) {
    "use strict";
    ns.WizardModel = function (translator) {
        var translate = translator,
            languageSelectionModel = new ns.LanguageSelectionViewModel(translate),
            licenceModel = new ns.LicenceViewModel(translate, ns.Gira.licenseData, languageSelectionModel),
            timeZonesModel = new ns.TimeZoneViewModel(translate),
            timeZoneContinentsModel = new ns.TimeZoneContinentViewModel(translate, timeZonesModel),
            worldsModel = new ns.WorldViewModel(translate),
            installationEnvironmentModel = new ns.InstallationEnvironmentViewModel(translate, worldsModel),
            finishWizardModel = new ns.FinishViewModel(translate, gds$, new window.Gira.DeviceConfigurationInterface(gds$)),
            networkModel = new ns.NetworkViewModel(translate),
            pageModels = [languageSelectionModel, licenceModel, timeZoneContinentsModel, timeZonesModel, installationEnvironmentModel, worldsModel, networkModel, finishWizardModel],
            activeIndex = ko.observable(0),
            isDeBouncing = false,
            pagingModel = {
                next: function () {
                    var currentModel = pageModels[activeIndex()];
                    if (!isDeBouncing && currentModel.isValid()) {
                        isDeBouncing = true;
                        activeIndex(Math.min(activeIndex() + 1, pageModels.length - 1));
                        setTimeout(function () {
                            isDeBouncing = false;
                        }, 300);
                    }
                },
                prev: function () {
                    activeIndex(Math.max(activeIndex() - 1, 0));
                },
                activeIndex: activeIndex
            },
            model = {
                languageSelectionModel: languageSelectionModel,
                licenceModel: licenceModel,
                timeZoneContinentsModel: timeZoneContinentsModel,
                timeZonesModel: timeZonesModel,
                installationEnvironmentModel: installationEnvironmentModel,
                worldsModel: worldsModel,
                networkModel: networkModel,
                finishWizardModel: finishWizardModel,
                paging: pagingModel,
                i18n: translate.i18n,
                isStarted: finishWizardModel.isStarted,
                start: function () {
                    finishWizardModel.start({
                        languageSelectionModel: languageSelectionModel,
                        timeZonesModel: timeZonesModel,
                        installationEnvironmentModel: installationEnvironmentModel,
                        worldsModel: worldsModel,
                        networkModel: networkModel
                    });
                },
                init: function (element) {
                    ns.CreateWizardSwiper();
                    translate.init("de", function () {
                        timeZoneContinentsModel.init();
                        installationEnvironmentModel.init();
                        ko.applyBindings(model, element);

                        gds$.connect('ws://localhost:8182/gds/api');
                        gds$.ready(function () {
                            gds$.setValue("400403", "0");
                        });
                    });
                }
            };

        return model;
    };
}(window));