/*jslint browser:true, todo: true*/
/*global $, ko*/

(function (ns) {
    'use strict';

    function calculatePixel(value, width, rangeMax, rangeMin) {
        return width / (rangeMax - rangeMin) * (value - rangeMin);
    }

    function Slider(options) {
        var self = this,
            rangeValue = options.initValue,
            rangeMin = options.minimum,
            rangeMax = options.maximum,
            rangeStep = options.steps,
            width = options.elementWidth,
            icons = options.icons,
            defaults = {
                infoText: ''
            },
            onValueChangeCallBack = options.onValueChangeCallBack;

        options = $.extend(defaults, options);

        self.value = ko.observable(rangeValue);
        self.min = ko.observable(rangeMin);
        self.max = ko.observable(rangeMax);
        self.step = ko.observable(rangeStep);
        self.scale = ko.observable(icons.scale);
        self.minimum = ko.observable(icons.minimum);
        self.maximum = ko.observable(icons.maximum);
        self.infoText = ko.observable(options.infoText);
        self.sliderColors = ko.computed(function () {
            return 'background: linear-gradient(to right,  #BEDC00 0%,#BEDC00 ' + calculatePixel(self.value(), width, rangeMax, rangeMin) + 'px,#DCDCDC ' + calculatePixel(self.value(), width, rangeMax, rangeMin) + 'px,#DCDCDC 366px)';
        });

        /*jslint unparam: true*/
        self.onValueChange = function (model, event) {
            self.value(event.target.value);
        };
        /*jslint unparam: false*/
        /*jslint unparam: true*/
        self.saveValueAndSend = onValueChangeCallBack;
        /*jslint unparam: false*/
    }

    ns.Slider = Slider;
}(window.Gira.DCS));
