/*jslint browser: true*/
/*global ko, $, */

(function (ns) {
    "use strict";
    var Messages = window.Gira.DCS.Messages;

    function DoorStation(saveCallbackFunc, config) {
        var saveCallback = saveCallbackFunc,
            isVisible = ko.observable(false),
            stationsList = ko.observableArray();

        return {
            init: function (menuObj) {
                var coll = menuObj.doorStations;
                stationsList.removeAll();
                coll.forEach(function (item) { stationsList.push(item); });
            },
            select: function (data) {
                saveCallback([Messages.setMenuValue.doorStationCall(data.key, data.value)], false);
            },
            isVisible: isVisible,
            stations: stationsList,
            label: config.label
        };
    }

    ns.DoorStation = DoorStation;
}(window.Gira.DCS));
