/*jslint browser: true*/
/*global _*/

(function (ns) {
    'use strict';
    var DCS = window.Gira.DCS,
        Urns = DCS.Urns,
        Globals = DCS.Globals,
        extractDigitsFromEndRegex = /(\d+$)/,
        makeSetValueMsg = function (urn, value) {
            return {
                request: {
                    command: 'SetValue',
                    urn: urn,
                    value: value
                },
                version: {
                    major: '1',
                    minor: '0',
                    text: '1.0'
                }
            };
        },
        makePressedMsg = function (urn, value) {
            return makeSetValueMsg(urn + ':Pressed', value);
        },
        makeGetValueMsg = function (urn) {
            return {
                request: {
                    command: 'GetValue',
                    urn: urn
                },
                version: {
                    major: '1',
                    minor: '0',
                    text: '1.0'
                }
            };
        },
        makeButtonMessages = function (geturn) {
            return {
                pressed: function () { return makePressedMsg(geturn(), "1"); },
                released: function () { return makePressedMsg(geturn(), "0"); },
                canceled: function () { return makePressedMsg(geturn(), "2"); }
            };
        },
        doorOpener = makeButtonMessages(function () {return Urns.doorOpener; }),
        ringTone = makeButtonMessages(function () {return Urns.ringTone; }),
        doorCall = makeButtonMessages(function () {return Urns.doorCall; }),
        light = makeButtonMessages(function () {return Urns.light; }),
        F1 = makeButtonMessages(function () {return Urns.F1; }),
        F2 = makeButtonMessages(function () {return Urns.F2; }),
        camera = makeButtonMessages(function () {return Urns.camera; }),
        doorGarage = makeButtonMessages(function () {return Urns.doorGarage; }),
        register = function (applicationId) {
            return {
                request: {
                    command: "RegisterApplication",
                    applicationId: applicationId,
                    pretty: "true"
                }
            };
        },
        registerUI = function () {
            return {
                request: {
                    command: "RegisterUI"
                }
            };
        },
        setConfiguration = function (ip, username, password) {
            return {
                request: {
                    command: "SetConfiguration",
                    object: {
                        urn: Urns.connectChannel,
                        metadata:
                            [{key: "IpAddress", value: ip}, {key: "Username", value: username}, {key: "Password", value: password}],
                        pretty: "true"
                    }
                }
            };
        },
        getIdFromName = function (urn) {
            return {
                request: {
                    command: "GetIdFromName",
                    urn: urn
                }
            };
        },
        setAppValue = function (key, value) {
            return {
                request: {
                    command: "SetAppValue",
                    appName: Globals.ApplicationName,
                    key: key,
                    value: value
                }
            };
        },
        getAppValue = function (key) {
            return {
                request: {
                    command: "GetAppValue",
                    appName: Globals.ApplicationName,
                    key: key
                }
            };
        },
        deleteAppValue = function (key) {
            return {
                request: {
                    command: "DeleteAppValue",
                    appName: Globals.ApplicationName,
                    key: key
                }
            };
        },
        getState = function (urn) {
            return urn.split(':')[urn.split(':').length - 1];
        },
        getMenuConfiguration = function () {
            return {
                request: {
                    command: "GetConfiguration",
                    object: {urn: Urns.menuChannel}
                }
            };
        },
        getDeviceConfig = function () {
            return {
                request: {
                    command: "GetDeviceConfig",
                    ipc: true
                }
            };
        },
        toCanonical = function (obj) {
            var urn = obj.response ? obj.response.request.urn : (obj.event.value ? obj.event.value.urn : ''),
                value = obj.response ? obj.response.value : (obj.event.value ? obj.event.value.new : ''),
                oldValue = obj.response ? obj.response.value : (obj.event.value ? obj.event.value.old : ''),
                request = obj.response ? obj.response.request : undefined,
                response = obj.response,
                event = obj.event;
            return {
                urn: urn,
                state: urn ? getState(urn) : undefined,
                value: value,
                oldValue : oldValue,
                request: request,
                response: response,
                event: event
            };
        },
        getMenuParameter = function (parameters, set, key) {
            return _.find(parameters, function (parameter) {
                return parameter.set === set && parameter.key === key;
            });
        },
        getIntValue = function (parameters, set, key) {
            var parameter = getMenuParameter(parameters, set, key),
                value = parameter !== undefined ? parseInt(parameter.value, 10) : 0;
            return isNaN(value) ? 0 : value;
        },
        getAudioValue = function (parameters, key) {
            return getIntValue(parameters, "Audio", key);
        },
        getOnOffValue = function (parameters, set, key) {
            var parameter = getMenuParameter(parameters, set, key);
            if (parameter === undefined) {
                return undefined;
            }
            return parameter.value === "On";
        },
        extractSetFromConfigParameters = function (parameters, set) {
            return _.reduce(parameters, function (extractedSet, parameter) {
                if (parameter.set === set) {
                    extractedSet.push(parameter);
                }
                return extractedSet;
            }, []);
        },
        menuConfigToObject = function (data) {
            var parameters = data.response.object.parameters,
                theCameras = extractSetFromConfigParameters(parameters, "Cameras"),
                theDoorStations = extractSetFromConfigParameters(parameters, "DoorStations"),
                theRingTones = extractSetFromConfigParameters(parameters, "RingTones"),
                theDoorCalls = _.reject(extractSetFromConfigParameters(parameters, "DoorCalls"), function (doorCall) { return doorCall.key === "Count" || doorCall.key.indexOf("Ringtone") >= 0; }),
                theDoorCallsRingTones = _.reject(extractSetFromConfigParameters(parameters, "DoorCalls"), function (doorCall) { return doorCall.key === "Count" || doorCall.key.indexOf("Name") >= 0; });

            function prepareDoorCalls(theDoorCalls, theDoorCallsRingTones) {
                var ringToneObj;
                theDoorCalls.forEach(function (item) {
                    item.keyIndex = extractDigitsFromEndRegex.exec(item.key)[0];
                    ringToneObj = _.find(theDoorCallsRingTones, function (element) {
                        return extractDigitsFromEndRegex.exec(element.key)[0] === item.keyIndex;
                    });
                    if (ringToneObj) {
                        item.ringTone = ringToneObj.value;
                    } else {
                        item.ringTone = "";
                    }
                });
                return theDoorCalls;
            }

            return {cameras: theCameras,
                    ringTones: theRingTones,
                    doorCalls: prepareDoorCalls(theDoorCalls, theDoorCallsRingTones),
                    microphoneGain: getAudioValue(parameters, "MicrophoneGain"),
                    ringToneVolume: getAudioValue(parameters, "RingtoneVolume"),
                    speakerVolume: getAudioValue(parameters, "SpeakerVolume"),
                    doorStations: theDoorStations,
                    automaticDoorOpener: getOnOffValue(parameters, "DoorOpenerAutomatic", "Status"),
                    recallTimeout: getIntValue(parameters, "Call", "RecallTimeout")
                };
        },
        setMenuValue = {
            speakerVolume: function (value) {
                return makeSetValueMsg(Urns.menuExecute, "Audio:SpeakerVolume:" + value);
            },
            microphoneGain: function (value) {
                return makeSetValueMsg(Urns.menuExecute, "Audio:MicrophoneGain:" + value);
            },
            ringToneVolume: function (value) {
                return makeSetValueMsg(Urns.menuExecute, "Audio:RingtoneVolume:" + value);
            },
            automaticDoorOpener: function (value) {
                return makeSetValueMsg(Urns.menuExecute, "DoorOpenerAutomatic:Status:" + value);
            },
            doorStationCall: function (key, value) {
                return makeSetValueMsg(Urns.menuExecute, "DoorStations:" + key + ":" + value);
            },
            showCamera: function (key, value) {
                return makeSetValueMsg(Urns.menuExecute, "Cameras:" + key + ":" + value);
            },
            playRingTone: function (key) {
                return makeSetValueMsg(Urns.menuExecute, 'RingTones:' + key);
            },
            doorCall: function (key, value) {
                return makeSetValueMsg(Urns.menuExecute, "DoorCalls:" + key + ":" + value);
            }
        };
    ns.Messages = {doorOpener: doorOpener, ringTone: ringTone, doorCall: doorCall, camera: camera, register: register,
                   registerUI: registerUI, setConfiguration: setConfiguration, light: light, doorGarage: doorGarage, F1: F1, F2: F2, toCanonical: toCanonical,
                   getIdFromName: getIdFromName,
                   setAppValue: setAppValue, getAppValue: getAppValue, deleteAppValue: deleteAppValue,
                   getValue: function (urn) { return makeGetValueMsg(urn); },
                   setValue: function (urn, value) { return makeSetValueMsg(urn, value); },
                   getMenuConfiguration: getMenuConfiguration,
                   getDeviceConfig: getDeviceConfig,
                   menuConfigToObject: menuConfigToObject,
                   setMenuValue: setMenuValue
        };
}(window.Gira.DCS));
//# sourceURL=dcs.messages.js