/*jslint browser: true*/
/*global $, ko*/
(function (ns) {
    "use strict";

    var displayViewModel = null,
        activeSlideInVm = 0,
        createCameraSwiper,
        DCS = window.Gira.DCS;

    function setNewCameraNameForPopUp(slideIndex) {

        var numberOfCameras = displayViewModel.cameras().length,
            newSlideText;

        if (slideIndex < 0) {
            slideIndex = 0;
        } else if (slideIndex > (numberOfCameras - 1)) {
            slideIndex = numberOfCameras - 1;
        }

        if (displayViewModel.cameras()[slideIndex] !== undefined) {
            newSlideText  = displayViewModel.cameras()[slideIndex].Text();
            displayViewModel.currentCameraName(newSlideText);
        }
    }

    function onTouchMove(swiper) {
        var touchXRel = (swiper.touches.currentX - swiper.touches.current) / (swiper.width / 2),
            activeSlideIndex =  isNaN(swiper.activeIndex) ? activeSlideInVm() : swiper.activeIndex;
        if (touchXRel > 0 && touchXRel < 1) {
            setNewCameraNameForPopUp(activeSlideIndex);
            displayViewModel.cameraPopUp.slideDownTextOpacity(1 - touchXRel);
        }
        if (touchXRel > 1) {
            setNewCameraNameForPopUp(activeSlideIndex + 1);
            displayViewModel.cameraPopUp.slideDownTextOpacity(Math.abs((1 - touchXRel)));
        }
        if (touchXRel < 0 && touchXRel > -1) {
            setNewCameraNameForPopUp(activeSlideIndex);
            displayViewModel.cameraPopUp.slideDownTextOpacity(1 - Math.abs(touchXRel));
        }
        if (touchXRel < -1) {
            setNewCameraNameForPopUp(activeSlideIndex - 1);
            displayViewModel.cameraPopUp.slideDownTextOpacity(Math.abs(1 - Math.abs(touchXRel)));
        }
    }

    function onTouchEnd(swiper) {
        setNewCameraNameForPopUp(swiper.activeIndex);
        displayViewModel.cameraPopUp.slideDownTextOpacity(1);
    }

    function destroy() {
        if (DCS.cameraSwiper) {
            DCS.cameraSwiper.destroy();
        }
        DCS.cameraSwiper = null;
    }

    function syncSwiperCurrentSlide(activeIndex) {
        if (DCS.cameraSwiper) {
            if (DCS.cameraSwiper.activeIndex !== activeIndex) {
                DCS.cameraSwiper.swipeTo(activeIndex, 0, false);
            }
        }
    }

    function swipeToActiveSlide(activeIndex) {
        if (DCS.cameraSwiper) {
            DCS.cameraSwiper.swipeTo(activeIndex, 0, false);
        }
    }

    createCameraSwiper = function (displayVm) {

        displayViewModel = displayVm;
        activeSlideInVm = displayVm.activeVideoSlideIndex;
        var cameraSwiper = $('.swiper-container-camera-view').swiper({
            mode: 'horizontal',
            useCSS3Transforms: false,
            moveStartThreshold: 1,
            initialSlide: displayVm.activeVideoSlideIndex,
            onTouchStart: function () {
                setNewCameraNameForPopUp(isNaN(cameraSwiper.activeIndex) ? activeSlideInVm : cameraSwiper.activeIndex);
                displayVm.popUpDisplayAdditional(displayVm.latestVideoIndex === 0);
                displayVm.cameraPopUp.slideDown(false);
            },
            onSlideChangeEnd: function (swiper) {
                var activeSlideIndex = swiper.activeIndex;
                displayVm.setUpActiveSlide(activeSlideIndex);
                displayVm.requestNewCameraStream();
            },
            onTouchEnd: onTouchEnd,
            onTouchMove: onTouchMove
        });
        return cameraSwiper;
    };
    ns.CameraSwiper = {reBind: createCameraSwiper, destroy: destroy, syncSwiperCurrentSlide: syncSwiperCurrentSlide, swipeToActiveSlide: swipeToActiveSlide};
}(window.Gira.DCS));
//# sourceURL=dcs.cameraSwiper.js