#!/bin/sh

me="gds-ubootenv-sync.sh"

logger -s "[$me] Enter."

CALLER=$(ps | grep "^ *$PPID" | awk '{print $NF}')
logger -s "[$me] Called by: ${CALLER}"

source /opt/gira/share/devicestack/ipmodule-vars

# Write back UBoot variables.
if [ -f ${SYSTEM_A_BOOTCOUNTER_FILE} ]
then
  bcA=`cat ${SYSTEM_A_BOOTCOUNTER_FILE} | tr -d '\040\011\012\015'`
  logger -s "[$me] Setting boot counter for system A to $bcA."
  fw_setenv bcA $bcA
else
  logger -s "[$me] Bootcounter file for system A not found!"
fi

if [ -f ${SYSTEM_B_BOOTCOUNTER_FILE} ]
then
  bcB=`cat ${SYSTEM_B_BOOTCOUNTER_FILE} | tr -d '\040\011\012\015'`
  logger -s "[$me] Setting boot counter for system B to $bcB."
  fw_setenv bcB $bcB
else
  logger -s "[$me] Bootcounter file for system B not found!"
fi

if [ -f ${BOOTSYSTEM_FILE} ]
then
  bootsystem=`cat ${BOOTSYSTEM_FILE} | tr -d '\040\011\012\015'`
  logger -s "[$me] Setting bootsystem to $bootsystem."
  fw_setenv bootsystem $bootsystem
  logger -s "[$me] Removing bootsystem file from extparam after transfer to U-Boot environment."
  rm ${BOOTSYSTEM_FILE}
fi

logger -s "[$me] Exit."

exit 0
