﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:import href="../xsltemplates.xsl"/>
  <xsl:import href="tile_structure.xsl"/>
  <xsl:output indent="yes" />
  <xsl:output method="html"/>
  <xsl:template match="/">
    <!-- set tileId variable -->
    <xsl:variable name="tileId">
      <xsl:call-template name="tileId"/>
    </xsl:variable>
    <!-- generate tile structure-->
    <div class="tile tile-small">
      <xsl:attribute name="id">
        <xsl:copy-of select="$tileId" />
      </xsl:attribute>
      <xsl:attribute name="data-switch-id">
        <xsl:value-of select="Channel/DataPoints/DataPoint[@Index='0']/@Id"/>
      </xsl:attribute>
      <xsl:attribute name="data-status-value-enabled">
        <xsl:value-of select="Channel/ShowStatusValue/@Enable" />
      </xsl:attribute>
      <xsl:attribute name="data-unit-value">
        <xsl:value-of select="Channel/ShowUnits"/>
      </xsl:attribute>
      <xsl:attribute name="data-unit-enabled">
        <xsl:value-of select="Channel/ShowUnits/@Enable"/>
      </xsl:attribute>
      <xsl:attribute name="data-adjustment-enabled">
        <xsl:value-of select="Channel/ValueAdjustment/@Enable"/>
      </xsl:attribute>
      <xsl:attribute name="data-basis-value">
        <xsl:value-of select="Channel/BasisValue/@Value"/>
      </xsl:attribute>
      <xsl:attribute name="data-scaling-info">
        <xsl:value-of select="Channel/@TypeURN = 'de.gira.schema.channels.ValueTransmitter2Byte'"/>
      </xsl:attribute>
      <xsl:attribute name="data-channel-index">
        <xsl:value-of select="Channel/@Index"/>
      </xsl:attribute>
      <xsl:attribute name="data-container-index">
        <xsl:value-of select="Channel/@ContainerIndex"/>
      </xsl:attribute>
      
      <xsl:call-template name="tileContent">
        <xsl:with-param name="statusText">
          <div class="tile-status-text t2gg">
            <xsl:value-of select="Channel/BasisValue/@Value" />
            <xsl:text> </xsl:text>
            <xsl:if test="Channel/ShowUnits/@Enable = 'true'">
              <xsl:value-of select="Channel/ShowUnits" />
            </xsl:if>
          </div>
        </xsl:with-param>
        <xsl:with-param name="controlElements">
          <xsl:call-template name="tileTriggerButton">
            <xsl:with-param name="Index" select="Channel/@Index" />
          </xsl:call-template>
        </xsl:with-param>
        <xsl:with-param name="tileHeader"></xsl:with-param>
      </xsl:call-template>
      <script type="text/javascript">
        (function(){
        var tileId = '<xsl:value-of select="$tileId"/>';
        var dataset = document.getElementById(tileId).dataset;
        var statusValueEnabled = dataset.statusValueEnabled === 'true';
        var unitEnabled = dataset.unitEnabled === 'true';
        var valueAdjustment = dataset.adjustmentEnabled === 'true';
        var scalingInfo =  dataset.scalingInfo === 'true';
        var suffix =  '-' + dataset.containerIndex + '-' + dataset.channelIndex;
        var spinningWheelId = 'spinnWheel' + suffix;
        var triggerButtonId = 'tile_trigger_button' + suffix;
        var basisValue = dataset.basisValue;

        eventsOnTile(tileId);
        if(valueAdjustment){
        registerValueTransmitter(tileId, spinningWheelId, dataset.unitValue, unitEnabled);
        }
        registerValueTriggerButton(dataset.switchId, triggerButtonId, tileId, scalingInfo, basisValue);

        <!-- ######################### set tile click action ######################### -->
        $('#' + tileId).on('tileAction',function(){
        NavbarController.getInstance().openDetailElement(this);
        });
        })();
      </script>
    </div>
  </xsl:template>
</xsl:stylesheet>
