﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:import href="../xsltemplates.xsl"/>
  <xsl:import href="tile_structure.xsl"/>
  <xsl:output indent="yes" />
  <xsl:output method="html"/>
  <xsl:template match="/">
    <!-- set tileId variable -->
    <xsl:variable name="tileId">
      <xsl:call-template name="tileId"/>
    </xsl:variable>
    <div class="tile tile-small">
      <xsl:attribute name="id">
        <xsl:copy-of select="$tileId" />
      </xsl:attribute>
      <xsl:attribute name="data-off-text">
        <xsl:value-of select="Channel/StatusTexts/Off"/>
      </xsl:attribute>
      <xsl:attribute name="data-on-text">
        <xsl:value-of select="Channel/StatusTexts/On"/>
      </xsl:attribute>
      <xsl:attribute name="data-unit-enabled">
        <xsl:value-of select="Channel/ShowUnits/@Enable"/>
      </xsl:attribute>
      <xsl:attribute name="data-unit-value">
        <xsl:value-of select="Channel/ShowUnits"/>
      </xsl:attribute>
      <xsl:attribute name="data-datapoint-id">
        <xsl:value-of select="Channel/DataPoints/DataPoint[@TypeURN='de.gira.schema.datapoints.String' and @Name='ResultString']/@Id" />
      </xsl:attribute>
      <xsl:attribute name="data-led-on">
        <xsl:text>{{statusled-</xsl:text>
        <xsl:value-of select="Channel/StatusLed/@On" />
        <xsl:text>}}</xsl:text>
      </xsl:attribute>
      <xsl:attribute name="data-led-off">
        <xsl:text>{{statusled-</xsl:text>
        <xsl:value-of select="Channel/StatusLed/@Off" />
        <xsl:text>}}</xsl:text>
      </xsl:attribute>
      <!-- generate tile structure-->
      <xsl:call-template name="tileContent">
        <xsl:with-param name="statusText">
          <div class="tile-status-text tile-status-text-long t2gg">
            <xsl:text>- - - </xsl:text>
            <xsl:if test="Channel/ShowUnits/@Enable = 'true'">
              <xsl:value-of select="Channel/ShowUnits"/>
            </xsl:if>
          </div>
        </xsl:with-param>
        <xsl:with-param name="controlElements"></xsl:with-param>
        <xsl:with-param name="tileHeader"></xsl:with-param>
      </xsl:call-template>
      <script type="text/javascript">
        (function(){
        var tileId = '<xsl:value-of select="$tileId"/>';
        var dataset = document.getElementById(tileId).dataset;
        var valueUnit = dataset.unitEnabled === 'true' ? dataset.unitValue : '';

        eventsOnTile(tileId);

        <xsl:choose>
          <xsl:when test="Channel/DataPoints/DataPoint[@TypeURN='de.gira.schema.datapoints.Switch']">
            registerStatusTextCaseSet(dataset.datapointId, dataset.onText, dataset.offText, tileId)
          </xsl:when>
            <xsl:when test="Channel/DataPoints/DataPoint[@TypeURN='de.gira.schema.datapoints.Percent'] or
                  Channel/DataPoints/DataPoint[@TypeURN='de.gira.schema.datapoints.Percent255']or
                  Channel/DataPoints/DataPoint[@TypeURN='de.gira.schema.datapoints.Byte']or
                  Channel/DataPoints/DataPoint[@TypeURN='de.gira.schema.datapoints.Int8']or
                  Channel/DataPoints/DataPoint[@TypeURN='de.gira.schema.datapoints.Int16']or
                  Channel/DataPoints/DataPoint[@TypeURN='de.gira.schema.datapoints.Int32']">
              registerStatusTemplateValueCaseSet(dataset.datapointId, tileId, valueUnit, true);
            </xsl:when>
          <xsl:otherwise>
            registerStatusTemplateValueCaseSet(dataset.datapointId, tileId, valueUnit, false);
          </xsl:otherwise>
        </xsl:choose>

        <xsl:if test="Channel/StatusLed/@Enable = 'true'">
          registerLedCaseSet(dataset.datapointId, dataset.ledOn, dataset.ledOff, tileId);
        </xsl:if>

        <!-- ######################### set tile click action ######################### -->
        $('#' + tileId).on('tileAction',function(){
        NavbarController.getInstance().openDetailElement(this);
        });
        })();
      </script>
    </div>
  </xsl:template>
</xsl:stylesheet>