﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:import href="../xsltemplates.xsl"/>
  <xsl:import href="tile_structure.xsl"/>
  <xsl:output indent="yes" />
  <xsl:output method="html"/>
  <xsl:template match="/">
    <!-- set tileId variable -->
    <xsl:variable name="tileId">
      <xsl:call-template name="tileId"/>
    </xsl:variable>
    <div class="tile tile-small">
      <xsl:attribute name="id">
        <xsl:copy-of select="$tileId" />
      </xsl:attribute>
      <xsl:attribute name="data-room-Container">
        <xsl:value-of select="Channel/RoomContainer" />
      </xsl:attribute>
      <!-- generate tile structure-->
      <xsl:call-template name="tileContent">
        <xsl:with-param name="statusText">
          <div class="tile-function-folder-text t2gg">
            <xsl:value-of select="Channel/FunctionFolderText" />
          </div>
        </xsl:with-param>
        <xsl:with-param name="controlElements">
        </xsl:with-param>
        <xsl:with-param name="tileHeader">
          <div class="container-content-count t3sw">
            <xsl:value-of select="Channel/ChannelCount"/>
          </div>
        </xsl:with-param>
      </xsl:call-template>
      <script type="text/javascript">
        (function(){
        var tileId = '<xsl:value-of select="$tileId"/>';
        var dataset = document.getElementById(tileId).dataset;
        eventsOnTile(tileId);

        <!-- ######################### set tile click action ######################### -->
        $('#' + tileId).on('tileAction',function(){
        NavbarController.getInstance().loadContainer(dataset.roomContainer, false, 0, undefined, 2);
        });
        })();
      </script>
    </div>
  </xsl:template>
</xsl:stylesheet>
