﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:import href="xsltemplates.xsl"/>
  <xsl:output indent="yes" />
  <xsl:output method="html"/>
  <xsl:template match="/">
    <div>
    <xsl:variable name="detailId">
      <xsl:text>detail-</xsl:text><xsl:value-of select="Channel/@ContainerIndex" />-<xsl:value-of select="Channel/@Index" /></xsl:variable>
    <xsl:call-template name="channel_detail_description_row"></xsl:call-template>
    <div class="detail">
      <xsl:attribute name="id"><xsl:copy-of select="$detailId" /></xsl:attribute>
      <xsl:attribute name="data-off-text">
        <xsl:value-of select="Channel/StatusTexts/Off"/>
      </xsl:attribute>
      <xsl:attribute name="data-on-text">
        <xsl:value-of select="Channel/StatusTexts/On"/>
      </xsl:attribute>
      <xsl:attribute name="data-unit-enabled">
        <xsl:value-of select="Channel/ShowUnits/@Enable"/>
      </xsl:attribute>
      <xsl:attribute name="data-unit-value">
        <xsl:value-of select="Channel/ShowUnits"/>
      </xsl:attribute>
      <xsl:attribute name="data-datapoint-id">
        <xsl:value-of select="Channel/DataPoints/DataPoint[@TypeURN='de.gira.schema.datapoints.String' and @Name='ResultString']/@Id" />
      </xsl:attribute>
      <xsl:attribute name="data-led-on">
        <xsl:text>{{statusled-</xsl:text>
        <xsl:value-of select="Channel/StatusLed/@On" />
        <xsl:text>}}</xsl:text>
      </xsl:attribute>
      <xsl:attribute name="data-led-off">
        <xsl:text>{{statusled-</xsl:text>
        <xsl:value-of select="Channel/StatusLed/@Off" />
        <xsl:text>}}</xsl:text>
      </xsl:attribute>
      <xsl:attribute name="data-extended-Text">
        <xsl:value-of select="Channel/ExtendedTexts/Text[@Index = 0]" />
      </xsl:attribute>
      
      <div class="status-container">
        <div class="detail-view-white">
          <div class="detail-status-background">
          <xsl:attribute name="id">
            status-container-<xsl:copy-of select="$detailId" />
          </xsl:attribute>
          <div class="detail-status-value T1sg">- - -</div>
          <xsl:if test="Channel/ShowUnits/@Enable = 'true'">
            <div class="detail-status-unit T1gg">
              <xsl:value-of select="Channel/ShowUnits" />
            </div>
          </xsl:if>
          <xsl:if test="Channel/StatusLed/@Enable = 'true'">
            <div class="detail-status-led"></div>
          </xsl:if>  
          <xsl:if test="Channel/ExtendedTexts/Text/@Index = '0'">
            <div class="detail-status-extended-text T3sg"/>
          </xsl:if>
        </div>
      </div>
      </div>
    </div>
    <script type="text/javascript">
      (function(){
        var detailId = '<xsl:value-of select="$detailId" />';
        var dataset = document.getElementById(detailId).dataset;  
        
        <xsl:if test="Channel/ShowUnits/@Enable = 'true'">
          var statusUnitCssPath = new Array(detailId, 'status-container', 'detail-status-unit');
          changeText(statusUnitCssPath, dataset.unitValue);
        </xsl:if>
        var statusValueCssPath = new Array(detailId, 'status-container', 'detail-status-value');
        var statusValueObj =  $('#' + detailId + ' .status-container .detail-status-value');
      <xsl:choose>
        <xsl:when test="Channel/DataPoints/DataPoint[@TypeURN='de.gira.schema.datapoints.Switch']">
          registerDetailStatusOnOffCaseSet(dataset.datapointId, dataset.onText, dataset.offText, statusValueCssPath);
        </xsl:when>
        <xsl:when test="Channel/DataPoints/DataPoint[@TypeURN='de.gira.schema.datapoints.Percent'] or
                  Channel/DataPoints/DataPoint[@TypeURN='de.gira.schema.datapoints.Percent255']or
                  Channel/DataPoints/DataPoint[@TypeURN='de.gira.schema.datapoints.Byte']or
                  Channel/DataPoints/DataPoint[@TypeURN='de.gira.schema.datapoints.Int8']or
                  Channel/DataPoints/DataPoint[@TypeURN='de.gira.schema.datapoints.Int16']or
                  Channel/DataPoints/DataPoint[@TypeURN='de.gira.schema.datapoints.Int32']">
          registerDetailStatusValueCaseSet(dataset.datapointId, statusValueCssPath, true);
        </xsl:when>
        <xsl:otherwise>
          registerDetailStatusValueCaseSet(dataset.datapointId, statusValueCssPath, false);
        </xsl:otherwise>
      </xsl:choose>
        <xsl:if test="Channel/StatusLed/@Enable = 'true'">
          var ledDivPath = new Array(detailId, 'status-container', 'detail-status-led');
          registerLedCaseSetOnCustomView(dataset.datapointId, dataset.ledOn, dataset.ledOff, ledDivPath);
        </xsl:if>
        <xsl:if test="Channel/ExtendedTexts/Text/@Index = '0'">
          var extTextCssPath = new Array(detailId, 'status-container', 'detail-status-extended-text');
          changeText(extTextCssPath, dataset.extendedText);
        </xsl:if>
      })();
    </script>
    </div>
  </xsl:template>
</xsl:stylesheet>

