﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:import href="xsltemplates.xsl"/>
    <xsl:output indent="yes" />
    <xsl:output method="html"/>
    <xsl:template match="/">
      <div>
      <xsl:variable name="detailId">detail-<xsl:value-of select="Channel/@ContainerIndex" />-<xsl:value-of select="Channel/@Index" /></xsl:variable>
        <xsl:call-template name="channel_detail_description_row"></xsl:call-template>
      <div class="detail detailflip">
        <xsl:attribute name="id"><xsl:copy-of select="$detailId" /></xsl:attribute>
        <xsl:attribute name="data-height-position-id">
          <xsl:value-of select="Channel/DataPoints/DataPoint[@Name='Position']/@Id"/>
        </xsl:attribute>
        <xsl:attribute name="data-height-position-state-id">
          <xsl:value-of select="Channel/DataPoints/DataPoint[@Name='PositionState']/@Id"/>
        </xsl:attribute>
        <xsl:attribute name="data-movement-id">
          <xsl:value-of select="Channel/DataPoints/DataPoint[@TypeURN='de.gira.schema.datapoints.Movement']/@Id"/>
        </xsl:attribute>
        <xsl:attribute name="data-stop-id">
          <xsl:value-of select="Channel/DataPoints/DataPoint[@Name='Stop']/@Id"/>
        </xsl:attribute>
        <xsl:attribute name="data-height-status-value-enabled">
          <xsl:value-of select="Channel/StatusValuePosition/@Enable"/>
        </xsl:attribute>
        <xsl:attribute name="data-container-index">
          <xsl:value-of select="Channel/@ContainerIndex"/>
        </xsl:attribute>
        <xsl:attribute name="data-count">
          <xsl:value-of select="Channel/@count"/>
        </xsl:attribute>
        <xsl:call-template name="shutterBlindAbsolutLayout">
          <xsl:with-param name="valueLeft" select="Channel/StatusValuePosition/@Enable"/>
          <xsl:with-param name="sliders">
            <div class="shutter-up sprites {{{{gc4_blind_up}}}}"></div>
            <div class="shutter-down sprites {{{{gc4_blind_down}}}}"></div>
            <div class="slider_center"></div>
            <div class="skala sprites {{{{gc4_dim_skala}}}}"> </div>
          </xsl:with-param>
        </xsl:call-template>
        
        <script type="text/javascript">
          (function(){
          var detailId = '<xsl:value-of select="$detailId" />';
          var dataset = document.getElementById(detailId).dataset;
          var valueText = dataset.heightStatusValueEnabled === 'true';         

          <xsl:if test="Channel/DataPoints/DataPoint/@TypeURN = 'de.gira.schema.datapoints.StepUpDown'">
          tsx.BlindAbsolute.eventsOnStop('#'+detailId, dataset.stopId);
          </xsl:if>
            initSlider('slider', 'center', 'left', dataset.heightPositionId, dataset.heightPositionStateId, dataset.movementId, globals.blind.animationSpeed, globals.blind.inUseTimer, valueText, '#'+detailId);


          <xsl:if test="Channel/TimeSwitches/@Enable ='true'">
            var timerFunctions = [{name: "heightPos", datapoint: dataset.heightPositionId, values: [0, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100]}];
            tsx.timer.registerTimer(detailId, 'blindShutter', dataset.count, timerFunctions);
          </xsl:if>

            })();
        </script>
      </div>
      </div>
    </xsl:template>
</xsl:stylesheet>

