﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:output indent="yes" />
  <xsl:output method="html"/>
  <xsl:template match="/">
/* breadcrumb */

/* rtc */
#rtc {
  position: relative;
  width: 444px;
  height: 470px;
  z-index: 1;
  background: #F5F5F5;
  bottom: 0;
  font-family: 'UniversNextLight';

}

.coverflip-background {
  position: absolute;
  height: 30px;
  width: 444px;
  top: 470px;
  background-color: #FFFFFF;
}

div#detail-top-rtr {
  background-color: transparent !important;
}

#rtc input {
  outline: none;
}

#rtc .hide {
  display: none;
}

/* rtc controller */
.rtc-controller {
  width: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.rtc-controller']/width" />px;
  height: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.rtc-controller']/height" />px;
  position: relative;
  text-align: center;
  box-sizing: border-box;
}

.rtc-controller .mask {
  pointer-events: none;
  position: absolute;
  z-index: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.scala']/z-index" />;
}

.rtc-controller .bg {
  position: absolute;
  top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.scala-bg']/top" />px;
  left: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.scala-bg']/left" />px;
}

.rtc-controller .knob-container {
  position: relative;
  z-index: 2;
  padding-top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.knob-container']/padding-top" />px;
}

.rtc-controller .knob {
  font-size: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.knob']/font-size" />px !important;
  width: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.knob-container']/width" />px;
  height: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.knob-container']/height" />px;
  color: rgb(56,56,56) !important;
}

.rtc-controller .event-blocker {
  width: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.event-blocker']/width" />px;
  height:<xsl:value-of select="/metrics/detail/metric[@key = 'RTR.event-blocker']/height" />px;
  left: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.event-blocker']/left" />%;
  top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.event-blocker']/top" />px;
  border-radius: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.event-blocker']/border-radius" />px;
  margin-left: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.event-blocker']/margin-left" />px;
  position: absolute;
}

.rtc-controller .inc,
.rtc-controller .dec {
  width: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.inc-dec']/width" />px;
  height: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.inc-dec']/height" />px;
  top:<xsl:value-of select="/metrics/detail/metric[@key = 'RTR.inc-dec']/top" />px;
  left: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.inc-dec']/left" />px;
  border-radius: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.inc-dec']/border-radius" />px;
  border: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.inc-dec']/border" />px solid rgb(180,180,180);
  margin: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.inc-dec']/margin" />;
  position: absolute;
  cursor: pointer;
  z-index: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.inc-dec']/z-index" />;
  -webkit-transform: translateZ(0);
  background-color: rgb(245,245,245);
  -webkit-box-shadow: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.inc-dec']/shadow" /> #fff, inset <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.inc-dec']/inset" /> #fff;
}

.rtc-controller .dec {
  left: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.dec']/left" />px;
}

.rtc-controller .incs,
.rtc-controller .decs{
  position: absolute;
  left: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.incs-decs']/left" />px;
  top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.incs-decs']/top" />px;
}

.rtc-controller .inc:before,
.rtc-controller .dec:before {
  content:"";
  display:block;
  position:absolute;
  border-radius: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.inc-dec-before']/border-radius" />px;
  top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.inc-dec-before']/top" />px;
  left: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.inc-dec-before']/left" />px;
  right: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.inc-dec-before']/right" />px;
  bottom: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.inc-dec-before']/bottom" />px;
  border: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.inc-dec-before']/border" />px solid transparent;
}

.rtc-controller .down {
  background-color: rgb(200,200,200);
  -webkit-box-shadow: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.down']/shadow" /> #fff;
}

.rtc-controller .details {
  pointer-events: none;
  position: absolute;
  z-index: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.details']/z-index" />;
  -webkit-transform: translateZ(0);
}

.rtc-controller .details span {
  display: block;
  position: absolute;
  width: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.details-span']/width" />px;
}

.rtc-controller .details .is {
  top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.details-is']/top" />px;
}

.rtc-controller .details .is-temp {
  top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.details-is-temp']/top" />px;
}

.rtc-controller .details .divider {
  display: block;
  position: absolute;
  top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.details-divider']/top" />px;
  left: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.details-divider']/left" />px;
}

.rtc-controller .details .set {
  top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.details-set']/top" />px;
}

.rtc-controller .details .set-temp {
  top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.details-set-temp']/top" />px;
}

.rtc-controller .details .set-unit {
  top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.details-set-unit']/top" />px;
}

.rtc-controller .details .divider1 {
  display: block;
  position: absolute;
  top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.details-divider1']/top" />px;
  left: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.details-divider1']/left" />px;
}

.rtc-controller .details .heating-cooling-dew-icon {
  position: absolute;
  top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.details-heating-cooling-status']/top" />px;
  left: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.details-heating-cooling-status']/left" />px;
  height: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.gc4_icon_heating']/height" />px;
  width: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.gc4_icon_heating']/width" />px;
}

.rtc-controller .details .heating-cooling-dew-icon .heating-cooling-status {
  margin-left: auto;
  margin-right: auto;
}

.rtc-controller .details .operation-mode-symbol {
  position: absolute;
  top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.details-operation-mode-symbol']/top" />px;
  left: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.details-operation-mode-symbol']/left" />px;
}

.rtc-controller .details .operation-mode-text {
  top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.details-operation-mode-text']/top" />px;
}

.rtc-controller .footer {
  position: absolute;
  left: 0;
  right: 0;
  top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.details-footer']/top" />px;
  text-align: center;
  z-index: 4;
}

.rtc-controller .btn.modes {
  position: relative;
  -webkit-transform: translateZ(0);
}


.rtc-controller .btn.modes .label {
  font-family: UniversNextMedium !important;
  line-height:inherit;
}

.rtc-controller .btn.modes .arrow-right {
  position: absolute;
  top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.details-footer-btn-modes-arrow-right']/top" />px;
  right: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.details-footer-btn-modes-arrow-right']/right" />px;
}

.rtc-ecomode-img {
  top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.rtc-ecomode-img']/top" />px;
  left: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.rtc-ecomode-img']/left" />px;
  position: absolute;
  display: none;
  z-index: 4;
  -webkit-transform: translateZ(0);
}

.rtc-lockmode-img {
  top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.rtc-lockmode-img']/top" />px;
  left: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.rtc-lockmode-img']/left" />px;
  position: absolute;
  display: none;
  z-index: 4;
  -webkit-transform: translateZ(0);
}

#rtc-modes-coverflip {
  position: absolute;
  width: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.rtc-modes-coverflip']/width" />px;
  height: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.rtc-modes-coverflip']/height" />px;
  top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.rtc-modes-coverflip']/top" />px;
}

#rtc-modes {
  position: absolute;
  width: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes']/width" />px;
  height: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes']/height" />px;
  z-index: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes']/z-index" />;
  background: #F4F4F4;
  top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes']/top" />px;
}
  
#rtc-mode-edit-view .header div {
  float: left;
}
  
#rtc-mode-edit-view .header,
#rtc-modes .header {
  height: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-header']/height" />px;
  line-height: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-header']/line-height" />px;
  box-sizing: border-box;
  padding-top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-header']/padding-top" />px;
  padding-left: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-header']/padding-left" />px;
  background: #EBEBEB;
}
  
#rtc-mode-edit-view .buttons,
#rtc-modes .buttons {
  height: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-buttons']/height" />px;
  border-top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-buttons']/border-height" />px solid #fff;
  border-bottom: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-buttons']/border-height" />px solid #C8C8C8;
  position: relative;
}

.rtcModeEdit ul,
#rtc-modes ul {
  margin: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-ul']/margin" />;
  padding: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-ul']/padding" />;
  list-style: none;
  height: initial;
}
  
.rtcModeEdit li,
#rtc-modes li {
  position: relative;
  overflow: hidden;
  cursor: pointer;
  margin: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-li']/margin" />;
  padding: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-li']/padding" />;
  border-top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-li']/border-height" />px solid #fff;
  border-bottom: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-li']/border-height" />px solid #C8C8C8;
  line-height: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-li']/line-height" />px;
}

#rtc-modes .li-oneandhalfline {
  height: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-li-oneandhalfline']/height" />px;
}

#rtc-modes .li-singleline {
  height: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-li-singleline']/height" />px;
}

#rtc-modes li .label {
  position: absolute;
  left: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-li-label']/left" />px;
  top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-li-label']/top" />px;
  line-height: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-li-label']/line-height" />px;
}

#rtc-modes li .label-oneandhalfline {
}

#rtc-modes li .label-singleline {
}
  
#rtc-modes li .temp-hot {
  position: absolute;
  top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-li-temp-hot']/top" />px;
  left: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-li-temp-hot']/left" />px;
  color: #DB3B3B;
}
  
#rtc-modes li .temp-cold {
  position: absolute;
  top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-li-temp-cold']/top" />px;
  left: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-li-temp-cold']/left" />px;
  color: #639FEF;
}
  
#rtc-modes .icon:first-child {
  height: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-icon']/height" />px;
  width: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-icon']/width" />px;
  position: absolute;
  left: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-icon']/left" />px;
}

#rtc-modes .icon-oneandhalfline:first-child {
  top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-icon-oneandhalfline']/top" />px;
}

#rtc-modes .icon-singleline:first-child {
 top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-icon-singleline']/top" />px;
}
  
#rtc-modes .icon.hot {
  position: absolute;
  left: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-icon-hot']/left" />px;
  top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-icon-hot']/top" />px;
}
  
#rtc-modes .icon.cold {
  position: absolute;
  left: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-icon-cold']/left" />px;
  top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-icon-cold']/top" />px;
}
  
#rtc-modes .icon.seperator {
  top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-icon-separator']/top" />px;
  left: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-icon-separator']/left" />px;
  position: absolute;
  width: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-icon-separator']/width" />px;
  height: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-icon-separator']/height" />px;
  background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,rgba(200,200,200,0)), color-stop(50%,rgba(200,200,200,1)), color-stop(100%,rgba(200,200,200,0)));
}
  
#rtc-modes .radio {
  position: absolute;
  left: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-radio']/left" />px;
  height: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-radio']/height" />px;
  width: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-radio']/width" />px;
  background: rgb(225, 225, 225);
  border-radius: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-radio']/border-radius" />px;
  box-shadow: inset 0 1px rgba(0,0,0,0.1), 0 1px #fff;
}

#rtc-modes .radio-oneandhalfline {
  top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-radio-oneandhalfline']/top" />px;
}

#rtc-modes .radio-singleline {
  top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-radio-singleline']/top" />px;
}

  /* active */
#rtc-modes li.down {
  background: #505050;
}
  
#rtc-modes li.down:after {
  content: '';
  position: absolute;
  left: 0;
  right: 0;
  top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-li-down']/top" />px;
  height: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-li-down']/height" />px;
  background: -webkit-linear-gradient(top, #141414 0%,#505050 100%);
  border: none;
}
  
#rtc-modes li.down .radio {
  box-shadow: none;
}
  
#rtc-modes li .radio.active:before {
  content: '';
  display: block;
  width: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-radio-active']/width" />px;
  height: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-radio-active']/height" />px;
  position: absolute;
  border-radius: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-radio-active']/border-radius" />px;
  left: 50%;
  top: 50%;
  margin-top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-radio-active']/margin-top" />px;
  margin-left: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-radio-active']/margin-left" />px;
  background: #3C3C3C;
}
  /* Fix for timer icon ploping in on rtc view */
#detail-top-rtr .timer-icon{
  -webkit-transform: translateZ(0);
  z-index: 4;
}
#rtc-modes li .arrow-right {
  position: absolute;
  left: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-li-arrow-right']/left" />px;
  top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-li-arrow-right']/top" />px;
}

#rtc-modes li.disabled span{
  color: #c8c8c8 !important;
}

.rtc-mode-extension-container {
  position: absolute;
  top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.mode-extension-container']/top" />px;
  left: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.mode-extension-container']/left" />px;
  height: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.mode-extension-container']/height" />px;
  width: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.mode-extension-container']/width" />px;
  z-index: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.mode-extension-container']/z-index" />;
  -webkit-transform: translateZ(0);
}

.rtc-mode-extension-container:before {
  content: "";
  display: block;
  position: absolute;
  top: -5px;
  left: -15px;
  right: -15px;
  bottom: -5px;
  border: 5px solid transparent;
}

.rtc-mode-extension-button {
  height:34px;
  width:34px;
  /* +jeweils 1px Kontur = 36px Gesamtgroesse*/
  -webkit-border-radius:18px;
  border: 1px solid rgb(180,180,180);
  -webkit-box-shadow:0px 1px 0px 0px #ffffff,
  0px 1px 0px 0px rgb(255,255,255) inset;
  background-color:transparent;
  display:inline-block;
  z-index: 4;
}

.rtc-mode-extension-button.down {
  border: 1px solid rgb(180,180,180) !important;
  background-color: rgb(200,200,200) !important;
  -webkit-box-shadow:0px 1px 0px 0px #fff !important;
  height:34px !important;
  width:34px !important;
}

.rtc-mode-extension-button.active {
  height:<xsl:value-of select="/metrics/detail/metric[@key = 'RTR.mode-extension-button']/height" />px;
  width:<xsl:value-of select="/metrics/detail/metric[@key = 'RTR.mode-extension-button']/width" />px;
  border: 0px solid rgb(180,180,180);
  -webkit-border-radius:18px;
  -webkit-box-shadow:0px 1px 0px 0px #ffffff;
  background-color: rgb(190,220,0);
  display:inline-block;
}

.rtc-mode-extension-img {
  position: absolute;
  top: 0px;
}

#rtr-hatch {
  position: absolute;
  top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.scala-bg']/top" />px;
  left: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.scala-bg']/left" />px;
  width: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.scala-bg']/width" />px;
  height: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.scala-bg']/height" />px;
  z-index: 3;
  -webkit-touch-callout: none;
  -webkit-user-select: none;
  -webkit-user-drag: none;
  -khtml-user-select: none;
  -moz-user-select: none;
  -ms-user-select: none;
  user-select: none;
  pointer-events: none;
}

.rtr-stop-knob-input {
  -webkit-touch-callout: none;
  -webkit-user-select: none;
  -webkit-user-drag: none;
  -khtml-user-select: none;
  -moz-user-select: none;
  -ms-user-select: none;
  user-select: none;
  pointer-events: none;
  color: #c8c8c8 !important;
}

#rtc-mode-edit-view{
  position: absolute;
  left: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.mode-edit-view']/left" />px;
  display: none;
  background-color: #F5F5F5;
}

#rtc-mode-edit-view .swiper-slide {
  width: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.mode-edit-view-swiper']/width" />px;
}

.rtcModeEdit{
  overflow: hidden;
  position: relative;
  width: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.mode-edit']/width" />px;
  height: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.mode-edit']/height" />px;
}

.rtcModeEdit li {
  height: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.mode-edit-li']/height" />px;
}

.rtcModeEdit .edit-temperature-headline {
  position: relative;
  top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.mode-edit-temperature-headline']/top" />px;
  height: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.mode-edit-temperature-headline']/height" />px;
  }

.rtcModeEdit .edit-temperature-selection {
  position: relative;
  height: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.mode-edit-temperature-selection']/height" />px;
  }


.rtcModeEdit .temp-hot,
.rtcModeEdit .temp-cold {
  position: absolute;
  top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.mode-edit-temp-hot-cold']/top" />px;
  left: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.mode-edit-temp-hot-cold']/left" />px;
}

.rtcModeEdit ul li .label {
  position: absolute;
  left: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-li-label']/left" />px;
  top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-li-label']/top" />px;
  line-height: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.modes-li-label']/line-height" />px;
}

.rtcModeEdit .temp {
  position: absolute;
  top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.mode-edit-temp']/top" />px;
}

.rtcModeEdit .temp-hot {
  color: #DB3B3B;
}

.rtcModeEdit .temp-cold {
  color: #639FEF;
}

.rtcModeEdit .icon.hot,
.rtcModeEdit .icon.cold {
  position: absolute;
  left: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.mode-edit-icon-hot-cold']/left" />px;
  top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.mode-edit-icon-hot-cold']/top" />px;
}

.rtcModeEdit .valuator .slot-machine{
  position: absolute;
  top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.valuator-slotmachine']/top" />px;
  height: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.valuator-slotmachine']/height" />px;
  left: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.valuator-slotmachine']/left" />px;
  width: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.valuator-slotmachine']/width" />px;
}

.rtcModeEdit .valuator .sw-frame{
  width: inherit;
  height: inherit;
  right: inherit;
}

.rtcModeEdit .valuator .sw-slots{
  padding-top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.valuator-slots']/padding-top" />px;
  right: inherit;
  width: inherit;
}

.rtcModeEdit .valuator .sw-slots ul {
  top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.valuator-slots-ul']/top" />px;
}

.rtcModeEdit .valuator li {
  padding: 0 <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.valuator-li']/padding" />px !important;
  height: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.valuator-li']/height" />px;
  border: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.valuator-li']/border" />px;
  line-height: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.valuator-li']/line-height" />px;
}

.rtcModeEdit .valuator .floatingpoint {
  position: absolute;
  top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.valuator-floatingpoint']/top" />px;
  left: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.valuator-floatingpoint']/left" />px;
}

.rtcModeEdit .valuator .unitLabel {
  top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.valuator-unitlabel']/top" />px;
}

.rtcModeEdit .temp-double-line {
  position: absolute;
  left: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.temp-double-line']/left" />px;
  border:none;
  border-top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.temp-double-line']/border" />px solid #c8c8c8;
  border-bottom: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.temp-double-line']/border" />px solid #ffffff;
  width: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.temp-double-line']/width" />px;
}

.rtcModeEdit .temp-double-line.upper {
  top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.temp-double-line-upper']/top" />px;
}

.rtcModeEdit .temp-double-line.lower {
  bottom: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.temp-double-line-lower']/bottom" />px;
}

.rtcModeEdit .valuator .gradient-top {
  position: absolute;
  top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.valuator-gradient-top']/top" />px;
  left: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.valuator-gradient-top']/left" />px;
  width: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.valuator-gradient-top']/width" />px;
  height: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.valuator-gradient-top']/height" />px;
}
  
.rtcModeEdit .valuator .gradient-bottom {
  position: absolute;
  top: initial;
  bottom: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.valuator-gradient-bottom']/bottom" />px !important;
  left: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.valuator-gradient-bottom']/left" />px;
  width: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.valuator-gradient-bottom']/width" />px;
  height: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.valuator-gradient-bottom']/height" />px;
}
  
#rtc-mode-edit-view .rtc-edit-scrollbar {
  position: absolute;
  bottom: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.rtc-edit-scrollbar']/bottom" />px;
  height: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.rtc-edit-scrollbar']/height" />px;
  width: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.rtc-edit-scrollbar']/width" />px;
  right: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.rtc-edit-scrollbar']/right" />px;
  -ms-touch-action: none;
  background-color: #FFFFFF;
  display: block !important;
}

.rtcModeEdit .rtc-temp-double-line{
  position: absolute;
  left: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.rtc-temp-double-line']/left" />px;
  border:none;
  border-top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.rtc-temp-double-line']/border-top" />px solid #c8c8c8;
  border-bottom: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.rtc-temp-double-line']/border-bottom" />px solid #ffffff;
  width: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.rtc-temp-double-line']/width" />px;
  margin-top: <xsl:value-of select="/metrics/detail/metric[@key = 'RTR.rtc-temp-double-line']/margin-top" />px;
}
  </xsl:template>
</xsl:stylesheet>