/*global window, navbarController, Gira, NavbarController, $*/

(function (ns) {
    'use strict';
    function TileController() {
        var self = this,
            Weather = window.Gira.Weather,
            onBack = function () { return undefined; };
        self.openView = function (viewLocation, backView) {
            var navigationBarController = NavbarController.getInstance(),
                rebind = function (rootElement) {
                    var content = $("<div class='world' id='weather-content' data-bind='template: {name: \"weather-template\"}'></div>");
                    content.on("remove", function () {
                        onBack();
                    });
                    rootElement.append(content);
                    Weather.Bootstrapper.rebindTo(content);
                };
            navigationBarController.loadWorld(viewLocation, backView, onBack, false, rebind);
        };
    }
    ns.Tile = new TileController();
    ns.TileController = TileController;
}(Gira.Weather.Controller));

//# sourceURL=weather.tile.controller.js