/*global ko, $, _, eventsOnSettingsEntry, openSettingsElement, NavbarController, registerEventsForPressButton*/
/*jslint browser: true*/

(function () {
    "use strict";
    var Log = window.Gira.Log,
        catchAll = function (action) {
            try {
                action();
            } catch (e) {
                Log.exception(e);
            }
        },
        findMenuId = function (element) {
            var parentWithMenu = $(element).closest(".menuPage");
            return parentWithMenu.attr('id');
        },
        appendDegree = function (element, valueAccessor) {
            var val = ko.utils.unwrapObservable(valueAccessor());
            ko.bindingHandlers.text.update(element, function () { return val + '°'; });
        };

    ko.bindingHandlers.weatherRenderWizardsButtons = {
        init: function (element, valueAccessor) {
            catchAll(function () {
                var descriptionRow = $(element).closest('.settings-swiper-container'),
                    containerDiv = $('<div></div>');
                descriptionRow.before(containerDiv);
                ko.renderTemplate("weather-settings-buttons-wizard-template", valueAccessor, {}, containerDiv[0], "replaceNode");
            });
        }
    };

    ko.bindingHandlers.weatherRenderStartWizardsButtons = {
        init: function (element, valueAccessor) {
            catchAll(function () {
                var descriptionRow = $(element).closest('.settings-swiper-container'),
                    containerDiv = $('<div></div>');
                descriptionRow.before(containerDiv);
                ko.renderTemplate("weather-settings-buttons-main-wizard-template", valueAccessor, {}, containerDiv[0], "replaceNode");
            });
        }
    };

    ko.bindingHandlers.weatherRenderOkCancelButtons = {
        init: function (element, valueAccessor) {
            catchAll(function () {
                var descriptionRow = $(element).closest('.settings-swiper-container'),
                    containerDiv = $('<div></div>');
                descriptionRow.before(containerDiv);
                ko.renderTemplate("weather-settings-buttons-template", valueAccessor, {}, containerDiv[0], "replaceNode");
            });
        }
    };

    /*jslint unparam:true*/
    ko.bindingHandlers.weatherWeiterButtonBinding = {
        init: function (element) {
            catchAll(function () {
                var nextBtn = $(element),
                    id = window.Gira.Globals.createGUID();
                element.id = id;
                registerEventsForPressButton(nextBtn,
                    function () { if (!nextBtn.hasClass('disabled')) {nextBtn.addClass('down'); } },
                    function () {nextBtn.removeClass('down'); },
                    function () {
                        if (!nextBtn.hasClass('disabled')) {
                            catchAll(function () {
                                var parentWithMenu = nextBtn.closest('.settings-container').find("[menu]");
                                openSettingsElement(parentWithMenu.attr('menu'), parentWithMenu.attr('submenu'));
                            });
                        }
                    });
            });
        }
    };
    /*jslint unparam:false*/

    ko.bindingHandlers.weatherCheckboxButtonBinding = {
        init: function (element, valueAccessor) {
            catchAll(function () {
                var boundProperty = valueAccessor,
                    settingsRow = $(element).closest(".settings-row");

                eventsOnSettingsEntry(settingsRow.attr("id"));

                settingsRow.on("settingsEntryAction", function () {
                    if (!settingsRow.hasClass('disabled')) {
                        catchAll(function () {
                            var value = boundProperty();
                            value(!value());
                        });
                    }
                });
            });
        }
    };

    ko.bindingHandlers.weatherFadeVisible = {
        init: function (element, valueAccessor) {
            // Initially set the element to be instantly visible/hidden depending on the value
            var value = valueAccessor();
            $(element).toggle(ko.utils.unwrapObservable(value)); // Use "unwrapObservable" so we can handle values that may or may not be observable
        },
        update: function (element, valueAccessor) {
            // Whenever the value subsequently changes, slowly fade the element in or out
            var value = valueAccessor();
            if (ko.utils.unwrapObservable(value)) {
                $(element).fadeIn(500);
            } else {
                $(element).fadeOut(500);
            }
        }
    };

    ko.bindingHandlers.weatherInputSearchIconBinding = {
        init: function (element, valueAccessor) {
            catchAll(function () {
                var input = $(element).parent().find("input"),
                    icon = $(element),
                    value = valueAccessor(),
                    showHideIcon = function () {
                        if (value() === undefined || value().length === 0) {
                            icon.show();
                        } else {
                            icon.hide();
                        }
                    };
                value.subscribe(function () {
                    catchAll(function () {
                        showHideIcon();
                    });
                });
                showHideIcon();
                input.focus(function () {
                    catchAll(function () {
                        showHideIcon();
                    });
                });
                input.focusout(function () {
                    catchAll(function () {
                        setTimeout(function () {
                            showHideIcon();
                        }, 100);
                    });
                });
            });
        }
    };

    /*jslint unparam:true*/
    ko.bindingHandlers.weatherSwiperCarousel = {
        init: function (element, valueAccessor, allBindings, viewModel) {
            catchAll(function () {
                var options = ko.utils.unwrapObservable(valueAccessor()),
                    swiper,
                    $elem = $(element),
                    swiperOptions,
                    weatherViewModel = viewModel;

                swiperOptions = options.swiperOptions || {};
                $elem.swiper(swiperOptions);

                swiper = $elem.data("swiper");

                weatherViewModel.mainDisplay.afterTownsChanged = function () {
                    if (swiper) {
                        swiper.swipeTo(0);
                        swiper.reInit();
                    }
                };

                ko.utils.domNodeDisposal.addDisposeCallback(element, function () {
                    if (swiper) {
                        swiper.destroy();
                        swiper = undefined;
                    }
                    if (weatherViewModel) {
                        weatherViewModel.afterTownsChanged = undefined;
                    }
                });

            });
        }
    };
    /*jslint unparam:false*/

    ko.bindingHandlers.weatherSettingsSwipeToZeroBinding = {
        init: function (element, valueAccessor) {
            var $swiper = $(element).closest('.settings-swiper-container');
            catchAll(function () {
                valueAccessor().subscribe(function () {
                    var swiper = $swiper.data('swiper');
                    if (swiper) {
                        swiper.swipeTo(0);
                    }
                });
            });
        }
    };

    ko.bindingHandlers.weatherScrollWeatherStationContent = {
        init: function (element) {
            function scroll($elem) {
                var y,
                    $scrollContainer,
                    diff;

                y = $elem.position().top + $elem.height();
                $scrollContainer = $elem.parent().parent();
                diff = $scrollContainer.innerHeight() - y;

                if (diff < 0) {
                    // animation of 300 ms needed here because we cannot make the scroll with css transition
                    $scrollContainer.animate({scrollTop: y}, 300);
                }
            }

            catchAll(function () {
                var $elem = $(element);
                $elem.on("webkitTransitionEnd", function () {
                    scroll($elem);
                });
            });
        }
    };

    ko.bindingHandlers.toDegrees = {
        init: function (element, valueAccessor) {
            catchAll(function () {
                appendDegree(element, valueAccessor);
            });
        },
        update: function (element, valueAccessor) {
            appendDegree(element, valueAccessor);
        }
    };

    ko.bindingHandlers.weatherDragDrop = {
        init: function (element, valueAccessor) {
            var menuId = "#" + findMenuId(element),
                $elem = $(menuId + " .weather-menu-sort"),
                saveCallback = valueAccessor();

            function saveData() {
                var newSorting = [],
                    index,
                    sortedGuiElements = $(menuId + " .weather-menu-sort .settings-row");

                for (index = 0; index < sortedGuiElements.length; index = index + 1) {
                    newSorting.push(ko.dataFor(sortedGuiElements[index]));
                }

                saveCallback(newSorting);
            }

            ko.utils.domNodeDisposal.addDisposeCallback(element, function () {
                if ($elem) {
                    $elem.dragsort('destroy');
                }
            });

            $elem.dragsort('destroy');
            $elem.dragsort({
                containment: ".weather-menu-sort",
                scrollContainer: menuId + " .settings-swiper-container",
                dragBetween: false,
                dragSelector: menuId + " .weather-settings-row-sortindicator",
                itemSelector: menuId + " .settings-row",
                placeHolderTemplate: '<div class="settings-row dsl-placeholder"></div>',
                dragStart: function () {
                    return undefined;
                },
                dragEnd: function () {
                    saveData();
                    return true;
                }
            });
        }
    };
    ko.bindingHandlers.weatherSetSliderClass = {
        update: function (element, valueAccessor) {
            catchAll(function () {
                var cssClass = valueAccessor(),
                    menuElement = $(element).closest('.menuPage'),
                    swiperContainer = menuElement.find('.settings-swiper-container'),
                    swiper = menuElement.data("settings-swiper");

                swiperContainer.addClass(cssClass);

                if (swiper) {
                    swiper.resizeFix(true);
                }
            });
        }
    };

    ko.bindingHandlers.weatherRadioButtonBinding = {
        init: function (element, valueAccessor) {
            catchAll(function () {
                var boundProperty = valueAccessor,
                    domElement = element,
                    settingsRow = $(element).closest(".weather-search-settings-row");

                eventsOnSettingsEntry(settingsRow.attr("id"));

                settingsRow.on("settingsEntryAction", function () {
                    catchAll(function () {
                        var value = boundProperty();
                        value($(domElement).val());
                    });
                });
            });
        }
    };
}());
//# sourceURL=weather.ko.extensions.js