/*jslint todo: true browser: true*/
/*global $, ko, getConnectionInfo*/
(function (ns) {
    "use strict";
    var Gira = window.Gira,
        Weather = Gira.Weather,
        Services = Weather.Services,
        Log = Gira.Log,
        models = null,
        init = function () {
            var weatherSymbols = new Weather.WeatherSymbols(),
                dataService,
                settings,
                displayVm,
                connectionWrapper,
                translationManager = new window.Gira.LanguageManager(),
                config,
                demoModeParam = window.getHTTPGetParameters('demomode'),
                isInDemoMode = demoModeParam !== 'undefined' && demoModeParam === 'true';

            if (ns.proxyConnection !== undefined) {
                return;
            }

            translationManager.register('weather', 'weather-lang.json');
            translationManager.register('weatherSymbols', 'weatherSymbols.json');

            translationManager.registerWithCallback("weather-license", function (config) {
                return "weather/eula." + (config.lang === "de" ? "de" : "en")  + ".json";
            });

            Weather.I18nTexts = translationManager.get('weather');
            Gira.I18n.init(Weather.I18nTexts, 'weather');

            config = {
                text: Weather.I18nTexts,
                eulaI18n: translationManager.get('weather-license')
            };

            weatherSymbols.init(translationManager.get('weatherSymbols'));

            if (isInDemoMode) {
                connectionWrapper = new Gira.Demo.DemoGdsConnectionWrapper();
            } else {
                connectionWrapper = new Services.ProxyConnectionWrapper("127.0.0.1", 9002);
            }
            ns.proxyConnection = new Gira.DcsToGdsConnector("Gira.G1.Weather", false, connectionWrapper);

            if (isInDemoMode) {
                settings = new Weather.Settings(ns.proxyConnection, config);
                ns.proxyConnection.registerListener(new Weather.WeatherSettingsConnectionListener(settings));
            } else {
                settings = new Weather.Settings(Gira.gdsConnection, config);
                Gira.gdsConnection.registerListener(new Weather.WeatherSettingsConnectionListener(settings));
            }

            settings.init();
            Weather.weatherSettings = settings;

            displayVm = new Weather.ViewModels.MainDisplayViewModel(weatherSymbols, Weather.I18nTexts.weatherBrandingTitle, config,
                window.fsm.API.SystemMessage.OpenWarning, window.Gira.dateTimeFormatsModel);

            if (isInDemoMode) {
                ns.proxyConnection.registerListener(new Weather.ViewModels.WeatherConnectionListener(displayVm));
            } else {
                Gira.gdsConnection.registerListener(new Weather.ViewModels.WeatherConnectionListener(displayVm));
            }

            Gira.ConfigLoader.onDeviceConfigLoaded(function (data) {
                var currentLanguage = translationManager.getCurrentConfig().lang,
                    searchLanguage = currentLanguage === "de" ? "de" : (currentLanguage === "nl" ? "nl" : "en");
                try {
                    dataService = new Services.ProxyDataService("password", data.response.deviceConfig.ipc.MacAddress1.replace(/\:/g, ''), searchLanguage, ns.proxyConnection);
                    ns.proxyConnection.registerListener(new Services.WeatherProxyConnectionListener(dataService));

                    settings.setDataService(dataService);
                    displayVm.setDataService(dataService);

                    dataService.init();
                } catch (ex) {
                    Log.exception(ex);
                }
            });

            models = {
                mainDisplay: displayVm
            };
        };

    ns.Bootstrapper = {
        models: models,
        rebindTo: function (domElement) {
            try {
                ko.applyBindings(models, domElement[0]);
                models.mainDisplay.init();
            } catch (e) {
                Log.exception(e);
            }
        },
        init: function () { try { init(); } catch (ex) { Log.exception(ex); } }
    };
}(window.Gira.Weather));

//# sourceURL=weather.bootstrapper.js