/*global window, Gira, document, $*/
/*jslint browser: true*/

window.Gira = window.Gira || {};
window.Gira.Demo = window.Gira.Demo || {};

(function (ns) {
    "use strict";
    var Log = Gira.Log;

    function DemoGdsConnectionWrapper() {
        var self = this,
            ws = new ns.DemoWebSocket(),
            createSocket = function () { return ws; },
            emptyHandler = function () { return undefined; },
            handlers = {
                onopen: emptyHandler(),
                onclose: emptyHandler(),
                onerror: emptyHandler(),
                onmessage: emptyHandler()
            };
        self.send = function (message) {
            ws.send(message);
        };

        self.onopen = function (ea) {
            handlers.onopen = ea;
            ws.setOnOpen(ea);
        };

        self.onclose = function (ea) {
            handlers.onclose = ea;
            ws.onclose = ea;
        };

        self.onerror = function (ea) {
            handlers.onerror = ea;
            ws.onerror = ea;
        };

        self.onmessage = function (ea) {
            handlers.onmessage = ea;
            ws.onmessage = ea;
        };

        self.readyState = function () {
            return ws.readyState;
        };

        self.close = function () {
            ws.close();
        };
        self.renew = function () {
            ws = createSocket();
            ws.onopen = handlers.onopen;
            ws.onclose = handlers.onclose;
            ws.onerror = handlers.onerror;
            ws.onmessage = handlers.onmessage;
        };
    }

    function DemoWebSocket() {
        var self = this,
            sendResponseCallback = function (message) {
                Log.verbose("DemoWebSocket::sendResponseCallback - " + message);
                if (self.onmessage) {
                    self.onmessage({data: message});
                }
            },
            weatherMachine = new Gira.Demo.DemoWeatherProxy(sendResponseCallback);

        self.setOnOpen = function (handler) {
            handler();
            self.readyState = 1;
        };
        self.onclose = undefined;
        self.onerror = undefined;
        self.onmessage = undefined;

        self.readyState = 3;

        self.send = function (message) {
            Log.verbose("DemoWebSocket::send - " + message);
            if (weatherMachine) {
                var msg = JSON.parse(message);
                weatherMachine.receive(msg);
            }
        };
    }

    ns.DemoWebSocket = DemoWebSocket;
    ns.DemoGdsConnectionWrapper = DemoGdsConnectionWrapper;
}(Gira.Demo));

//# sourceURL=demo.gdsConnectionWrapper.js