/*global ko, $, gds$, _*/
/*jslint browser: true*/

(function (ns, ko) {
    "use strict";

    function TimeZoneContinentViewModel(translate, timeZoneViewModel) {
        var continents = ko.observableArray(),
            selected = ko.observable(),
            selectedIcon = ko.observable(""),
            background = ko.observable("icon-continent_bg");

        function init() {
            var self = this,
                data = JSON.parse($.ajax({
                    url: "setup-wizard/timeZones.json",
                    async: false
                }).responseText),
                continentData = _.map(data.continents, function (continent) {
                    return _.extend(continent, {name: translate.i18n(continent.translationId)});
                });
            self.continents(continentData);
        }

        selected.subscribe(function (continentId) {
            var continent = _.find(continents(), function (continent) {
                return continent.value === continentId;
            });

            if (continent) {
                selectedIcon(continent.icon);
                timeZoneViewModel.init(continent.timeZoneIds);
            }
        });

        return {
            pageTitle: translate.i18n('pageTimeZoneContinentsTitle'),
            pageInfo: translate.i18n('pageTimeZoneContinentsInfo'),
            continents: continents,
            selected: selected,
            selectedIcon: selectedIcon,
            background: background,
            init: init,
            isValid: function () { return !!selected(); }
        };
    }
    ns.TimeZoneContinentViewModel = TimeZoneContinentViewModel;

}(window, ko));
