/*global ko, globals, $*/
/*jslint browser:true*/
(function (ns) {
    "use strict";
    ns.ShutterRelativeModel = function (config, tsx) {
        var stepId = config.stepId,
            moveId = config.moveId,
            stepMoveThreshold = config.stepMoveThreshold,
            slatThreshold = config.slatThreshold,
            connection = config.connection,
            isInMove = false,
            Button = function (stepValue) {
                var isUp = ko.observable(true),
                    moveTimeoutId,
                    slatTimeoutId;
                return {
                    down: function () {
                        isUp(false);
                        connection.setValue(stepId, stepValue);
                        moveTimeoutId = setTimeout(function () {
                            connection.setValue(moveId, stepValue);
                            isInMove = true;
                            slatTimeoutId = setTimeout(function () {
                                isInMove = false;
                            }, slatThreshold);
                        }, stepMoveThreshold);
                    },
                    up: function () {
                        clearTimeout(moveTimeoutId);
                        clearTimeout(slatTimeoutId);

                        if (isInMove) {
                            isInMove = false;
                            connection.setValue(stepId, stepValue);
                        }
                        isUp(true);

                    },
                    isUp: isUp
                };
            },
            buttonUp = new Button(0),
            buttonDown = new Button(1);

        function registerTimer() {
            var timerFunctions;
            if (config.timerEnabled) {
                timerFunctions = [{ name: "move", datapoint: moveId, values: [0, 1]}];
                tsx.timer.registerTimer(config.detailId, 'blindShutterRelative', config.count, timerFunctions);
            }
        }

        registerTimer();

        return {
            buttonUp: buttonUp,
            buttonDown: buttonDown,
            areAllButtonsUp: ko.computed(function () {
                return buttonUp.isUp() && buttonDown.isUp();
            })
        };
    };
    ko.bindingHandlers.giraSwipeableButton = {
        init: function (element, valueAccessor) {
            var handler = valueAccessor(),
                startHandler = handler.start,
                endHandler = handler.end,
                element$ = $(element),
                undeliveredTouchStart = false,
                deliveredTouchStart = false,
                startTimeId,
                onButtonDown = function () {
                    undeliveredTouchStart = true;
                    startTimeId = setTimeout(function () {
                        startHandler();
                        undeliveredTouchStart = false;
                        deliveredTouchStart = true;
                    }, globals.general.clickDelay);
                },
                onButtonUp = function () {
                    if (undeliveredTouchStart) {
                        clearTimeout(startTimeId);
                        undeliveredTouchStart = false;
                        startHandler();
                        // without timeout user will not be able to see button down effect on short button click
                        setTimeout(function () {
                            endHandler();
                        }, globals.general.clickDelay);
                    }
                    if (deliveredTouchStart) {
                        deliveredTouchStart = false;
                        endHandler();
                    }
                };
            if (!(document.documentElement.hasOwnProperty("ontouchstart"))) {
                element$.on('mousedown', function () {
                    onButtonDown();
                });
                element$.on('mouseup', function () {
                    onButtonUp();
                });
            } else {
                element$.on('touchstart', function () {
                    onButtonDown();
                });
                element$.on('touchmove', function () {
                    clearTimeout(startTimeId);
                    undeliveredTouchStart = false;
                });
                element$.on('touchend', function () {
                    onButtonUp();
                });
            }
        }
    };
}(window));
