/*global ko*/
/*jslint browser: true*/
(function (ns) {
    "use strict";

    function KnxReliableModel(networkInterface, i18nTexts, fsm) {
        var checked = ko.observable(false),
            initState = false;

        function hasChanged() {
            return initState !== checked();
        }

        function onChange(isOn) {
            initState = isOn;
            checked(initState);
        }

        return {
            init: function () {
                checked(initState);
                networkInterface.on(networkInterface.events.onKnxReliableChanged, onChange);
            },
            ok: function () {
                if (hasChanged()) {
                    fsm.OpenConfirmation(i18nTexts.menuConfigNetworkTypeConfirmMessage,
                        function () {
                            var useReliable = checked();
                            networkInterface.network.isKnxReliable(useReliable);
                            networkInterface.rebootDevice();
                        },
                        // cancel button: close popup
                        function () {
                            fsm.CloseConfirmation();
                        });
                    return false;
                }
                return true;
            },
            cancel: function () { return undefined; },
            toggle: {
                checked: checked,
                isVisible: true,
                label: i18nTexts.menuConfigNetworkReliableSwitchText
            },
            i18nTexts: i18nTexts
        };
    }
    ns.KnxReliableModel = KnxReliableModel;
}(window.Gira));

