﻿function Sound() {
    this._status = false;
    this._played = false;
};

Sound.prototype.getStatus = function () {
    return this._status;
};

Sound.prototype.setStatus = function (status) {
    this._status = status;
};

Sound.prototype.isPlayed = function () {
    return this._played;
};

Sound.prototype.setPlayed = function (played) {
    this._played = played;
};

Sound.prototype.loadStatusForSystemMenu = function () {
    this.setSystemMenuText();
};

/**
 * Sets the status, menu text according
 * to the current configuration mode
 * 
 */
Sound.prototype.toogleConfigurationMode = function () {
    this.toggleStatus();
    this.setSystemMenuText();
};

/**
 * Sets the menu text according to the current sound 
 * configuration status 
 */
Sound.prototype.setSystemMenuText = function () {
    var parent = _findElement(new Array("sound", "text"));

    if (this.getStatus()) {
        parent.text("Klicksound an");
    }
    else {
        parent.text("Klicksound aus");
    }

};

/**
 * Toggels the sound configuration status 
 */
Sound.prototype.toggleStatus = function () {
    if (this.getStatus()) {
        this.setStatus(false);
    }
    else {
        this.setStatus(true);
    }

};

/**
 * Plays the click sound
 */
Sound.prototype.playClickSound = function () {
    this.setPlayed(false);
    //player div id
    if (this._status) {
        document.getElementById('player').play();
        this.setPlayed(true);
    }
};

/**
 * set click sounds on all elements which are not triggerd from menucontroller
 */
Sound.prototype.bindPlaySounds = function () {
    var selectors = ['.button', '.dim'];
    var that = this;
    $.each(selectors, function (key, value) {
        $('body').on("mousedown", value, function () {
            that.playClickSound();
        });
    });
};