/*jslint todo: true browser: true*/
/*global $, ko, window*/

(function (ns) {
    "use strict";

    if (ns.ConfigLoader) {
        return;
    }

    function ConfigLoader() {
        var callbacks = [],
            deviceConfigMessage;

        function getDeviceConfig() {
            return {
                request: {
                    command: "GetDeviceConfig",
                    ipc: true
                }
            };
        }

        function onDeviceConfigLoaded(callback) {
            if (deviceConfigMessage) {
                callback(deviceConfigMessage);
            } else {
                callbacks.push(callback);
            }
        }

        function init(connection) {
            connection.registerListener({onMessage: function (message) {
                if (message.response && message.response.request.command === 'GetDeviceConfig') {
                    if (deviceConfigMessage) {
                        return;
                    }
                    deviceConfigMessage = message;
                    callbacks.forEach(function (callback) {
                        callback(message);
                    });

                    callbacks = [];
                }
            },
                onError: function () { return undefined; },
                onOpen: function () { return undefined; },
                onClose: function () { return undefined; }
                });
            connection.sendMessage(getDeviceConfig());
        }

        return {
            init: init,
            onDeviceConfigLoaded: onDeviceConfigLoaded
        };
    }

    ns.ConfigLoader = new ConfigLoader();

}(window.Gira));

//# sourceURL=gira.config.loader.js