/*jslint browser: true*/
/*global Gira*/

(function (dcs) {
    'use strict';

    function Timer(delay) {
        var timerId, remaining = delay * 1000, self = this, callbackFunction;

        self.setCallback = function (callback) {
            callbackFunction = callback;
        };

        self._getCallback = function () {
            return callbackFunction();
        };

        self.pause = function () {
            window.clearTimeout(timerId);
        };

        self.start = function () {
            timerId = window.setTimeout(function () {
                self._getCallback();
            }, remaining);

        };
    }

    dcs.Timer = Timer;
}(Gira.DCS.Utils));
//@ sourceURL=dcs.timer.js