/* To share the web socket with the application, we have to use the gds query implementation */
/*jslint browser: true*/
(function (ns) {
    "use strict";
    var Messages = window.Gira.DCS.Messages,
        create = function (gdsQuery) {
            var DCS = window.Gira.DCS,
                Urns = DCS.Urns,
                query = gdsQuery,
                listeners = [],
                dcsConnectId = "dcsConnectId",
                configuration = {ip: "", userName: "", password: ""},
                registerListener = function (listener) {
                    listeners.push(listener);
                },
                sendMessage = function (message) {
                    query.send(JSON.stringify(message));
                },
                whenIsGetIdFromNameResponse = function (response, continueWithId) {
                    if (response && response.request && response.request.command === "GetIdFromName") {
                        if (response.request.urn === Urns.connectChannel && response.request.dcsId === dcsConnectId) {
                            continueWithId(response.id);
                        }
                    }
                },
                receive = function (event) {
                    whenIsGetIdFromNameResponse(event.response, function (id) {
                        sendMessage(Messages.setConfiguration(configuration.ip, configuration.userName, configuration.password, id));
                    });

                    listeners.forEach(function (listener) {
                        listener.onMessage(event);
                    });
                },
                whenConnected = function (action) {
                    if (query.isConnected()) {
                        action();
                        return;
                    }
                    setTimeout(function () {
                        whenConnected(action);
                    }, 100);
                },
                initialize = function (ip, userName, password) {
                    configuration.ip = ip;
                    configuration.userName = userName;
                    configuration.password = password;
                    whenConnected(function () {
                        var idFromNameMessage = Messages.getIdFromName(Urns.connectChannel);
                        idFromNameMessage.dcsId = dcsConnectId;
                        sendMessage(idFromNameMessage);
                    });
                };
            query.addEventMsgHandler(receive);
            return {registerListener: registerListener, sendMessage: sendMessage, initialize: initialize};
        };
    ns.GdsQueryConnector = {create: create};
}(window.Gira.DCS));
//# sourceURL=dcs.gdsQueryConnector.js

