﻿/*jslint todo: true browser: true */
/*global $, ko, getConnectionInfo, window, location, console, _ */
(function dcsBootstrap(ns) {
    'use strict';
    var Gira = window.Gira,
        DCS = window.Gira.DCS,
        States = DCS.ButtonStates,
        SettingsConfig = DCS.SettingsConfig,
        NotificationIcons = DCS.NotificationIcons,
        Messages = DCS.Messages,
        Urns = DCS.Urns,
        Log = Gira.Log,
        pageOptions = window.Gira.DCS.PageOption,
        dcsToGdsConnector = Gira.gdsConnection,
        init = function () {
            var ButtonViewmodel = DCS.Viewmodels.ButtonViewmodel,
                displayVm,
                bellVm,
                doorVm,
                cameraVM,
                doorCallVm,
                f1Vm,
                f2Vm,
                tileController = new DCS.Controller.TileController(function () {
                    displayVm.close();
                    DCS.CameraSwiper.destroy();
                }, window.fsm.API.TK),
                buttonsModel,
                setUrnsOnButtons = function () {
                    bellVm.urn = Urns.ringTone;
                    doorVm.urn = Urns.doorOpener;
                    cameraVM.urn = Urns.camera;
                    doorCallVm.urn = Urns.doorCall;
                    f1Vm.urn = Urns.F1;
                    f2Vm.urn = Urns.F2;
                },
                onDeviceNameResolved = function (deviceName) {
                    Urns.init(deviceName);
                    setUrnsOnButtons();
                    DCS.ConnectionState.onConnected(dcsToGdsConnector);
                },
                settings,
                pageModel,
                displayOptions,
                cameraOptions,
                doorOptions,
                bellOptions,
                doorCallOptions,
                f1Options,
                f2Options;
            cameraOptions = {
                connection: dcsToGdsConnector,
                states: States.camera,
                messages: Messages.camera
            };
            doorOptions = {
                connection: dcsToGdsConnector,
                states: States.doorOpener,
                messages: Messages.doorOpener
            };
            bellOptions = {
                connection: dcsToGdsConnector,
                states: States.ringTone,
                messages: Messages.ringTone
            };
            doorCallOptions = {
                connection: dcsToGdsConnector,
                states: States.doorCall,
                messages: Messages.doorCall
            };
            f1Options = {
                connection: dcsToGdsConnector,
                states: States.functionKeys,
                messages: Messages.F1
            };
            f2Options = {
                connection: dcsToGdsConnector,
                states: States.functionKeys,
                messages: Messages.F2
            };
            displayOptions = {
                NotificationIcons: NotificationIcons,
                messages: DCS.DisplayMainMessages,
                connection: dcsToGdsConnector,
                cameraMessages: Messages.cameraVideo
            };

            bellVm = new ButtonViewmodel(bellOptions);
            doorVm = new ButtonViewmodel(doorOptions);
            cameraVM = new ButtonViewmodel(cameraOptions);
            doorCallVm = new ButtonViewmodel(doorCallOptions);
            f1Vm = new DCS.Viewmodels.ButtonViewmodel(f1Options);
            f2Vm = new DCS.Viewmodels.ButtonViewmodel(f2Options);

            buttonsModel = { buttons: [cameraVM, bellVm, doorVm, doorCallVm, f1Vm, f2Vm]};

            settings = new DCS.Settings(dcsToGdsConnector, SettingsConfig, onDeviceNameResolved, window.tsx.StatusbarController);

            DCS.Mediastream.init(window.navigator, window.URL);
            displayVm = new DCS.Viewmodels.DisplayViewmodel(displayOptions, DCS.Mediastream.Video);

            DCS.dcsSettings = settings;

            DCS.Controller.Tile = tileController;

            buttonsModel.buttons.forEach(function (button) {
                dcsToGdsConnector.registerListener(new DCS.DcsToGdsConnectionListener(button));
            });

            dcsToGdsConnector.registerListener(new DCS.DcsToGdsConnectionListener(tileController));

            dcsToGdsConnector.registerListener(new DCS.DcsToGdsConnectionListener(displayVm));

            dcsToGdsConnector.registerListener(new DCS.DcsToGdsConnectionListener(settings));

            DCS.ConnectionState.init(window.fsm.API.SystemMessage, DCS.ConnectionStates);
            dcsToGdsConnector.registerListener(new DCS.DcsToGdsConnectionListener(DCS.ConnectionState));

            Gira.I18n.init(DCS.I18nTexts, 'dcs');

            pageModel = {
                buttons: [cameraVM,  f1Vm, bellVm, doorVm, f2Vm, doorCallVm],
                displayViewModel: displayVm,
                tileGridLineCss: ko.observable(pageOptions.tileGridLine),
                brandingTitle: ko.observable(pageOptions.brandingTitle)
            };

            ns.Bootstrapper.rebindTo = function (domElement) {
                try {
                    ko.applyBindings(pageModel, domElement[0]);
                    DCS.cameraSwiper = DCS.CameraSwiper.reBind(displayVm);
                    displayVm.setDefaults();
                } catch (e) {
                    Log.exception(e);
                }
            };
            ns.Bootstrapper.buttons = buttonsModel.buttons;
            ns.Bootstrapper.settings = settings;
        };

    ns.Bootstrapper = {init: function () { try { init(); } catch (e) { Log.exception(e); } }};
}(window.Gira.DCS));
//# sourceURL=dcs.bootstrapper.js
