#!/bin/sh

me="[userdata.sh]"

echo "${me} Enter."

# Load ipmodule variables
. /opt/gira/share/devicestack/ipmodule-vars

if ! [ -d ${MP_USERDATA} ]
then
    echo "${me} Mount point for userdata partition does not exist and can not be created due to read-only filesystem!"
    echo "${me} Setting bootcounter for booted system to 3."
    echo "3" > ${EXTPARAM}/booted_boot_counter
    ${ENVIRONMENT_SYNC_SCRIPT}
    echo "${me} Reboot due to fatal error!"
    ${REBOOT}
fi

case "$1" in
  start)
    echo -n "${me} Checking userdata fs ... "
    if [ ! -f ${UD_MOUNTED_FILE} ]
    then
      echo "done."
      echo -n "${me} Mounting userdata fs ... "
      $MOUNT -o rw,suid,sync,noatime ${UD_BLOCKDEV} ${MP_USERDATA}
      if [ ! "$(cat /proc/mounts | grep ${MP_USERDATA})" == "" ]
      then
        echo "done."
        echo "${me} Updating mount info."
        touch ${UD_MOUNTED_FILE}
        echo "${me} Creating FWU directory."
        mkdir -p ${UD_FWU_DIR}
        logger -t "${me} userdata.initd" -s "Creating directories..."
        mkdir -p ${MP_USERDATA}/knxstack
      else
        echo "failed."
        echo "Executing factory reset."
        echo "enabled" > ${FACTORY_RESET_FILE}
#        ${FACTORY_RESET}
        echo "Rebooting NOW!"
        ${REBOOT}
      fi
    else
      echo "skipped (already mounted)."
    fi
    ;;
  stop)
    echo -n "${me} Checking userdata fs ... "
    if [ -f ${UD_MOUNTED_FILE} ]
    then
      echo "done."
      echo -n "${me} Unmounting userdata fs ..."
      sync
      $UMOUNT ${MP_USERDATA}
      if [ "$(cat /proc/mounts | grep ${MP_USERDATA})" == "" ]
      then
        echo "done."
      else
        echo "failed."
        echo "${me} Logging open filehandles to ${MP_USERDATA}/ofhandles1."
        /usr/sbin/lsof | /bin/grep '${MP_USERDATA/}' > ${MP_USERDATA}/ofhandles1
        echo "${me} Trying again."
        ${GIRA_BIN}/killEmAll-G1
        ${GIRA_BIN}/gapp stop
        ${GIRA_BIN}/gsplash-write "QUIT"
        sleep 1
        sync
        $UMOUNT ${MP_USERDATA}
        if [ "$(cat /proc/mounts | grep ${MP_USERDATA})" == "" ]
        then
          echo "${me} Unmounting userdata succeeded after killing all Gira Apps!"
        else
          echo "${me} Second umount failed after killing all gira apps."
          echo "${me} Logging open filehandles to ${MP_USERDATA}/ofhandles2."
          /usr/sbin/lsof | /bin/grep '${MP_USERDATA/}' > ${MP_USERDATA}/ofhandles2
        fi
      fi
    else
      echo "skipped (not mounted)."
    fi
    ;;
  *)
    echo "Usage: $0 (start|stop)"
    exit 1
esac

echo "${me} Exit."

exit 0
