#!/bin/sh
#
# Factory reset script for Gira G1 RTR.
# This script also should work for G1 HLK. G1 Android is unknown but we expect
# further work to do so that it would be possible to run it.
#
# For the sd card reset there is a check if it is possible to write to the card.
# If not the script will exit.
# Content of /opt/extparam/device_guid is writen as a file located on the sd card
# in resetted_devices/${DEVICE_GUID} so that it is possible to identify already
# factory resetted devices and to be able to prohibit factory-reset loops.
#
# In case of the GDS-API performed reset the file FACTORY_RESET_FILE becomes deleted.
# In case of the sd card reset the file EMERGENCY_FACTORY_RESET_FILE will not be
# deleted so that it might be possible to reset several devices with the same card.
#
# A reset log is written to sd card wich contains a timestamp and the device_guid.
#
me="[factory-reset.sh]"
echo "${me} Enter."

source /opt/gira/share/devicestack/ipmodule-vars

USERDATA_SUCCESSFULLY_FORMATTED=88
# Try to write this file to sd card and exit if it fails.
SD_CARD_TEST_FILE=${MP_CARD}/testfile
DEVICE_GUID=$(cat ${EXTPARAM}/device_guid | tr -d '\040\011\012\015')
RESETTED_GUIDS_DIRECTORY=${MP_CARD}/resetted_devices
# If this file is recognized on the sd card the device has already been
# resetted using this card. The file needs to be removed so it works again.
DEVICE_RESETTED_FILE=${RESETTED_GUIDS_DIRECTORY}/${DEVICE_GUID}
SD_CARD_RESET_LOG=${RESETTED_GUIDS_DIRECTORY}/reset.log

format_device()
{
  echo "${me} Factory reset found enabled. Cleaning userdata partition."
  echo "${me} Reformatting ${UD_BLOCKDEV}."
  /sbin/mkfs.ext3 ${UD_BLOCKDEV}
  USERDATA_SUCCESSFULLY_FORMATTED=$?
  sync
}

sdcard_reset()
{
  touch ${SD_CARD_TEST_FILE}
  if ! [ 0 -eq $? ]
  then
    echo "${me} Failed to write to sd-card. Aborting factory reset!"
    return
  fi
  rm -f ${SD_CARD_TEST_FILE}
  echo "${me} SD card is writable"
  
  if ! [ -d ${RESETTED_GUIDS_DIRECTORY} ]
  then
  echo "${me} Create ${RESETTED_GUIDS_DIRECTORY}"
    mkdir -p ${RESETTED_GUIDS_DIRECTORY}
  else
    if [ -f ${DEVICE_RESETTED_FILE} ]
    then
    echo "${me} Found file for this device on card. Skip format"
      echo "" >> ${SD_CARD_RESET_LOG}
      echo "[$(date +"%d.%m.%Y %R")] Factory reset via sd card rejected." >> ${SD_CARD_RESET_LOG}
      echo "[$(date +"%d.%m.%Y %R")] To reenable it for this device remove the file resetted_devices/${DEVICE_GUID}." >> ${SD_CARD_RESET_LOG}
      echo "" >> ${SD_CARD_RESET_LOG}
      return
    fi
  fi
  
  format_device

  if [ 0 -eq ${USERDATA_SUCCESSFULLY_FORMATTED} ]
	then
    touch ${DEVICE_RESETTED_FILE}
    echo "[$(date +"%d.%m.%Y %R")] Performed factory-reset via SD-Card for ${DEVICE_GUID}." >> ${SD_CARD_RESET_LOG}
  fi
}

for reset_file in "${EMERGENCY_FACTORY_RESET_FILE}" "${FACTORY_RESET_FILE}"
do
	if [ -f "$reset_file" ]
	then
	echo "${me} Handling factory_reset for file: ${reset_file}"
		# cat file and remove spaces, newlines, cariagereturns and tabs if any.
		FACTORY_RESET_CONDITION=$(cat ${reset_file} | tr -d '\040\011\012\015')
		if [ "enabled" = "${FACTORY_RESET_CONDITION}" ]
		then
		echo "${me} Found reset enabled for ${reset_file}"
		  if [ "${reset_file}" = "${EMERGENCY_FACTORY_RESET_FILE}" ]
			then
			echo "${me} Handling reset from SD card."
			  sdcard_reset
			else
			  format_device
			fi

			if [ 0 -eq ${USERDATA_SUCCESSFULLY_FORMATTED} ]
			then
			  echo "${me} Removing ${FACTORY_RESET_FILE}"
			  rm -f ${FACTORY_RESET_FILE}
			fi
		fi
	fi
done

if [ 0 -eq ${USERDATA_SUCCESSFULLY_FORMATTED} ]
then
  echo "${me} Done."
else
  echo "${me} Nothing to do."
fi
exit 0

