#!/bin/bash

function export_gpios
{
  if [ ! -d /sys/class/gpio/gpio38 ]; then
    echo "exporting GPIO38 (PHY_RSTn)"
    echo 38 > /sys/class/gpio/export
  fi

  if [ ! -d /sys/class/gpio/gpio39 ]; then
    echo "exporting GPIO39 (PHY_INT)"
    echo 39 > /sys/class/gpio/export
  fi
}

function unexport_gpios
{

  if [ -d /sys/class/gpio/gpio38 ]; then
    echo "unexporting GPIO38 (PHY_RSTn)"
    echo 38 > /sys/class/gpio/unexport
  fi

  if [ -d /sys/class/gpio/gpio39 ]; then
    echo "unexporting GPIO39 (PHY_INT)"
    echo 39 > /sys/class/gpio/unexport
  fi
}

export unexport_gpios

trap "{ unexport_gpios; exit; }" EXIT

function enable_ethernet
{
  export_gpios
  echo "enable ethernet"
  echo out > /sys/class/gpio/gpio38/direction
  echo 0 > /sys/class/gpio/gpio38/value
  echo out > /sys/class/gpio/gpio39/direction
  echo 1 > /sys/class/gpio/gpio39/value
  echo 1 > /sys/class/gpio/gpio38/value
  ifconfig eth0 up
}

function disable_ethernet
{
  ifconfig eth0 down
  export_gpios
  echo "disable ethernet"
  echo out > /sys/class/gpio/gpio38/direction
  echo 1 > /sys/class/gpio/gpio38/value
  echo out > /sys/class/gpio/gpio39/direction
  echo 0 > /sys/class/gpio/gpio39/value
}

command=$1
case ${command} in
enable)
 enable_ethernet
 ;;
disable)
 disable_ethernet
 ;;
reenable)
 disable_ethernet
 unexport_gpios
 enable_ethernet
 ;;
*)
 echo "usage: $(basename $0) enable|disable|reenable"
 exit 1
 ;;
esac

exit 0
